/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.util.text.AbsolutePosition;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInfo;
import org.openl.util.text.TextInterval;

public class SourceLocator {
    protected TextInfo textInfo;

    public SourceLocator(TextInfo textInfo) {
        this.textInfo = textInfo;
    }

    protected int[] calcBbox(ISyntaxNode node, int[] bbox) {
        if (node == null) {
            return bbox;
        }
        ILocation loc = node.getSourceLocation();
        if (loc != null) {
            int start = loc.getStart().getAbsolutePosition(this.textInfo);
            int end = loc.getEnd().getAbsolutePosition(this.textInfo);
            if (bbox == null) {
                bbox = new int[]{start, end};
            } else {
                bbox[0] = Math.min(bbox[0], start);
                bbox[1] = Math.max(bbox[1], end);
            }
        }
        int N = node.getNumberOfChildren();
        for (int i = 0; i < N; ++i) {
            bbox = this.calcBbox(node.getChild(i), bbox);
        }
        return bbox;
    }

    public TextInterval getSourceLocation(SyntaxNodeException error) {
        int[] nArray;
        ILocation loc = error.getLocation();
        if (loc == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = loc.getStart().getAbsolutePosition(this.textInfo);
            nArray = nArray2;
            nArray2[1] = loc.getEnd().getAbsolutePosition(this.textInfo);
        }
        int[] bbox = nArray;
        bbox = this.calcBbox(error.getSyntaxNode(), bbox);
        return bbox != null ? new TextInterval(new AbsolutePosition(bbox[0]), new AbsolutePosition(bbox[1])) : null;
    }

    public TextInterval getSourceLocation(ISyntaxNode node) {
        int[] bbox = this.calcBbox(node, null);
        return bbox != null ? new TextInterval(new AbsolutePosition(bbox[0]), new AbsolutePosition(bbox[1])) : null;
    }

    public TextInfo getTextInfo() {
        return this.textInfo;
    }
}

