/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.syntax.impl.BinaryNode;
import org.openl.syntax.impl.EmptyNode;
import org.openl.syntax.impl.ISyntaxConstants;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.syntax.impl.LiteralNode;
import org.openl.syntax.impl.NaryNode;
import org.openl.syntax.impl.UnaryNode;
import org.openl.util.text.TextInterval;

public class SyntaxTreeBuilder
implements ISyntaxConstants {
    List<SyntaxNodeException> parseErrors;
    IOpenSourceCodeModule module;
    Stack<Object> stack = new Stack();

    public void addError(SyntaxNodeException exc) {
        if (this.parseErrors == null) {
            this.parseErrors = new ArrayList<SyntaxNodeException>();
        }
        this.parseErrors.add(exc);
    }

    public void bop(String type, TextInterval pos) {
        ISyntaxNode right = this.pop();
        ISyntaxNode left = this.pop();
        this.push(new BinaryNode(type, pos, left, right, this.module));
    }

    public void emptyStatement(String type, TextInterval pos) {
        this.push(new EmptyNode(type, pos, this.module));
    }

    public IOpenSourceCodeModule getModule() {
        return this.module;
    }

    public SyntaxNodeException[] getSyntaxErrors() {
        return this.parseErrors == null ? new SyntaxNodeException[]{} : this.parseErrors.toArray(new SyntaxNodeException[this.parseErrors.size()]);
    }

    public ISyntaxNode getTopnode() {
        switch (this.stack.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.pop();
            }
        }
        if (this.parseErrors != null && this.parseErrors.size() > 0) {
            return this.pop();
        }
        ISyntaxNode node = this.pop();
        this.addError(SyntaxNodeExceptionUtils.createError("More than one syntax node on stack:\nSource:\n" + node.getModule().getCode(), null, node));
        return node;
    }

    public void identifier(String type, TextInterval pos, String image) {
        this.push(new IdentifierNode(type, pos, image, this.module));
    }

    public void literal(String type, TextInterval pos, String image) {
        this.push(new LiteralNode(type, pos, image, this.module));
    }

    public Object marker() {
        Marker marker = new Marker();
        this.stack.push(marker);
        return marker;
    }

    public void nop(String type, TextInterval pos, boolean[] args) {
        int n = args.length;
        ISyntaxNode[] nodes = new ISyntaxNode[n];
        for (int i = n - 1; i >= 0; --i) {
            nodes[i] = args[i] ? this.pop() : null;
        }
        this.push(new NaryNode(type, pos, nodes, this.module));
    }

    public void nop(String type, TextInterval pos, int args) {
        this.push(new NaryNode(type, pos, this.popN(args), this.module));
    }

    public void notImplemented(String type) {
        throw new RuntimeException(type + " has not been implemented yet");
    }

    ISyntaxNode pop() {
        Object x = this.stack.pop();
        if (x instanceof ISyntaxNode) {
            return (ISyntaxNode)x;
        }
        return null;
    }

    protected ISyntaxNode[] popN(int n) {
        ISyntaxNode[] nodes = new ISyntaxNode[n];
        for (int i = 0; i < n; ++i) {
            nodes[n - 1 - i] = this.pop();
        }
        return nodes;
    }

    public ISyntaxNode[] popToMarker(Object marker) {
        int size = this.stack.size();
        for (int i = 0; i < size; ++i) {
            if (this.stack.get(size - i - 1) != marker) continue;
            ISyntaxNode[] sn = this.popN(i);
            this.stack.pop();
            return sn;
        }
        throw new RuntimeException("Marker not found");
    }

    void push(ISyntaxNode sn) {
        this.stack.push(sn);
    }

    public void setModule(IOpenSourceCodeModule module) {
        this.module = module;
    }

    public void toMarker(String type, TextInterval pos, Object marker) {
        this.push(new NaryNode(type, pos, this.popToMarker(marker), this.module));
    }

    public void uop(String type, TextInterval pos) {
        ISyntaxNode left = this.pop();
        this.push(new UnaryNode(type, pos, left, this.module));
    }

    static class Marker {
        Marker() {
        }
    }
}

