/*
 * Decompiled with CFR 0.152.
 */
package org.openl.syntax.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openl.exception.OpenLCompilationException;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.util.text.AbsolutePosition;
import org.openl.util.text.TextInterval;

public class Tokenizer {
    private static final int EOF = -1;
    private static String TOKEN_TYPE = "token";
    private static Map<String, Tokenizer> tokenizers = new HashMap<String, Tokenizer>();
    private boolean[] delimitersTable = new boolean[0];

    public Tokenizer(String delimiters) {
        this.makeTable(delimiters);
    }

    private void makeTable(String delimiters) {
        int i;
        if (StringUtils.isEmpty((String)delimiters)) {
            return;
        }
        char min = '\u0000';
        for (i = 0; i < delimiters.length(); ++i) {
            if (delimiters.charAt(i) <= min) continue;
            min = delimiters.charAt(i);
        }
        this.delimitersTable = new boolean[min + 1];
        for (i = 0; i < delimiters.length(); ++i) {
            this.delimitersTable[delimiters.charAt((int)i)] = true;
        }
    }

    private boolean isDelimiter(int character) {
        return character < this.delimitersTable.length && this.delimitersTable[character];
    }

    private IdentifierNode firstToken(IOpenSourceCodeModule source) throws OpenLCompilationException {
        try {
            int character;
            Reader reader = source.getCharacterStream();
            int startToken = 0;
            int position = 0;
            StringBuffer buffer = null;
            do {
                character = reader.read();
                ++position;
                if ((character == -1 || this.isDelimiter(character)) && buffer != null) {
                    TextInterval location = new TextInterval(new AbsolutePosition(startToken), new AbsolutePosition(position));
                    return new IdentifierNode(TOKEN_TYPE, location, buffer.toString().trim(), source);
                }
                if (buffer == null) {
                    buffer = new StringBuffer();
                    startToken = position;
                }
                buffer.append((char)character);
            } while (character != -1);
            return new IdentifierNode(TOKEN_TYPE, new TextInterval(new AbsolutePosition(0), new AbsolutePosition(0)), "", source);
        }
        catch (IOException e) {
            throw new OpenLCompilationException("Parsing error", (Throwable)e, null, source);
        }
    }

    public IdentifierNode[] parse(IOpenSourceCodeModule source) throws OpenLCompilationException {
        ArrayList<IdentifierNode> nodes = new ArrayList<IdentifierNode>();
        try {
            int character;
            Reader reader = source.getCharacterStream();
            int startToken = 0;
            int position = -1;
            StringBuffer buffer = null;
            do {
                character = reader.read();
                ++position;
                if (character == -1 || this.isDelimiter(character)) {
                    if (buffer == null) continue;
                    TextInterval location = new TextInterval(new AbsolutePosition(startToken), new AbsolutePosition(position));
                    IdentifierNode node = new IdentifierNode(TOKEN_TYPE, location, buffer.toString().trim(), source);
                    buffer = null;
                    nodes.add(node);
                    continue;
                }
                if (buffer == null) {
                    buffer = new StringBuffer();
                    startToken = position;
                }
                buffer.append((char)character);
            } while (character != -1);
        }
        catch (IOException e) {
            throw new OpenLCompilationException("Parsing error", (Throwable)e, null, source);
        }
        return nodes.toArray(new IdentifierNode[nodes.size()]);
    }

    public static IdentifierNode firstToken(IOpenSourceCodeModule source, String delimiter) throws OpenLCompilationException {
        return Tokenizer.getTokenizer(delimiter).firstToken(source);
    }

    public static IdentifierNode[] tokenize(IOpenSourceCodeModule source, String delimiter) throws OpenLCompilationException {
        return Tokenizer.getTokenizer(delimiter).parse(source);
    }

    private static synchronized Tokenizer getTokenizer(String delimeter) {
        Tokenizer tokenizer = tokenizers.get(delimeter);
        if (tokenizer == null) {
            tokenizer = new Tokenizer(delimeter);
            tokenizers.put(delimeter, tokenizer);
        }
        return tokenizer;
    }
}

