/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openl.binding.exception.DuplicatedMethodException;
import org.openl.binding.exception.DuplicatedVarException;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaNoAggregateInfo;
import org.openl.util.AOpenIterator;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ADynamicClass
extends AOpenClass {
    private static final int MAX_DIM = 5;
    private String name = "<anonymous class>";
    protected Map<String, IOpenField> fieldMap;
    private Map<MethodKey, IOpenMethod> methodMap = new HashMap<MethodKey, IOpenMethod>();
    private Class<?> instanceClass;
    private IOpenClass[] arrayTypes = new IOpenClass[5];

    public ADynamicClass(IOpenSchema schema, String name, Class<?> instanceClass) {
        super(schema);
        this.name = name;
        this.instanceClass = instanceClass;
        this.fieldMap = this.fieldMap();
        this.addMethod(new OpenConstructor(this));
    }

    public void addField(IOpenField field) {
        Map<String, IOpenField> fields = this.fieldMap();
        if (fields.containsKey(field.getName())) {
            throw new DuplicatedVarException("", field.getName());
        }
        this.fieldMap().put(field.getName(), field);
        this.addFieldToLowerCaseMap(field);
    }

    public void addMethod(IOpenMethod method) {
        MethodKey key = new MethodKey(method);
        Map<MethodKey, IOpenMethod> methods = this.methodMap();
        if (methods.containsKey(key)) {
            throw new DuplicatedMethodException(String.format("Method '%s' have bean already defined for class '%s'", key.toString(), this.name), method);
        }
        this.methodMap().put(key, method);
    }

    @Override
    protected Map<String, IOpenField> fieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, IOpenField>();
        }
        return this.fieldMap;
    }

    @Override
    public IAggregateInfo getAggregateInfo() {
        return JavaNoAggregateInfo.NO_AGGREGATE;
    }

    public String getDisplayName(int mode) {
        return this.name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    public void setInstanceClass(Class<?> instanceClass) {
        this.instanceClass = instanceClass;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return false;
    }

    @Override
    public boolean isInstance(Object instance) {
        return false;
    }

    @Override
    protected Map<MethodKey, IOpenMethod> methodMap() {
        return this.methodMap;
    }

    @Override
    public Iterator<IOpenClass> superClasses() {
        return AOpenIterator.empty();
    }

    protected IOpenClass[] getArrayTypes() {
        return this.arrayTypes;
    }

    public static class OpenConstructor
    implements IOpenMethod {
        IOpenClass openClass;

        OpenConstructor(IOpenClass openClass) {
            this.openClass = openClass;
        }

        public IOpenClass getDeclaringClass() {
            return this.openClass;
        }

        public String getDisplayName(int mode) {
            return this.openClass.getDisplayName(mode);
        }

        public IMemberMetaInfo getInfo() {
            return null;
        }

        public IOpenMethod getMethod() {
            return this;
        }

        public String getName() {
            return this.openClass.getName();
        }

        public IMethodSignature getSignature() {
            return IMethodSignature.VOID;
        }

        public IOpenClass getType() {
            return this.openClass;
        }

        public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
            return this.openClass.newInstance(env);
        }

        public boolean isStatic() {
            return true;
        }

        public String toString() {
            return this.openClass.getName();
        }
    }
}

