/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.binding.exception.AmbiguousVarException;
import org.openl.binding.impl.cast.CastFactory;
import org.openl.binding.impl.cast.IOpenCast;
import org.openl.domain.IDomain;
import org.openl.domain.IType;
import org.openl.meta.IMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.CastingMethodCaller;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.impl.MethodDelegator;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AOpenClass
implements IOpenClass {
    protected IOpenSchema schema;
    private IOpenField indexField;
    protected IMetaInfo metaInfo;
    protected Map<String, IOpenField> uniqueLowerCaseFieldMap = null;
    protected Map<String, List<IOpenField>> nonUniqueLowerCaseFieldMap = null;

    protected AOpenClass(IOpenSchema schema) {
        this.schema = schema;
    }

    protected synchronized void addFieldToLowerCaseMap(IOpenField f) {
        if (this.uniqueLowerCaseFieldMap == null) {
            return;
        }
        String lname = f.getName().toLowerCase().replace(" ", "");
        if (this.uniqueLowerCaseFieldMap.containsKey(lname)) {
            this.initNonUniqueMap();
            ArrayList<IOpenField> ff = new ArrayList<IOpenField>(2);
            ff.add(this.uniqueLowerCaseFieldMap.get(lname));
            ff.add(f);
            this.nonUniqueLowerCaseFieldMap.put(lname, ff);
            this.uniqueLowerCaseFieldMap.remove(lname);
        } else if (this.nonUniqueLowerCaseFieldMap != null && this.nonUniqueLowerCaseFieldMap.containsKey(lname)) {
            this.nonUniqueLowerCaseFieldMap.get(lname).add(f);
        } else {
            this.uniqueLowerCaseFieldMap.put(lname, f);
        }
    }

    protected abstract Map<String, IOpenField> fieldMap();

    @Override
    public Iterator<IOpenField> fields() {
        Map<String, IOpenField> fieldMap = this.getFields();
        return fieldMap == null ? null : fieldMap.values().iterator();
    }

    @Override
    public Map<String, IOpenField> getFields() {
        HashMap<String, IOpenField> fields = new HashMap<String, IOpenField>();
        Iterator<IOpenClass> superClasses = this.superClasses();
        while (superClasses.hasNext()) {
            fields.putAll(superClasses.next().getFields());
        }
        fields.putAll(this.fieldMap());
        return fields;
    }

    @Override
    public Map<String, IOpenField> getDeclaredFields() {
        return new HashMap<String, IOpenField>(this.fieldMap());
    }

    public IOpenClass getArrayType(int dim) {
        return JavaOpenClass.getOpenClass(this.getInstanceClass()).getArrayType(dim);
    }

    public IDomain<?> getDomain() {
        return null;
    }

    @Override
    public IOpenField getField(String fname) {
        return this.getField(fname, true);
    }

    @Override
    public IOpenField getField(String fname, boolean strictMatch) {
        IOpenField f = null;
        if (strictMatch) {
            Map<String, IOpenField> m = this.fieldMap();
            IOpenField iOpenField = f = m == null ? null : m.get(fname);
            if (f != null) {
                return f;
            }
            return this.searchFieldFromSuperClass(fname, strictMatch);
        }
        String lfname = fname.toLowerCase();
        Map<String, IOpenField> uniqueLowerCaseFields = this.getUniqueLowerCaseFieldMap();
        if (uniqueLowerCaseFields != null && (f = uniqueLowerCaseFields.get(lfname)) != null) {
            return f;
        }
        Map<String, List<IOpenField>> nonUniqueLowerCaseFields = this.getNonUniqueLowerCaseFieldMap();
        List<IOpenField> ff = nonUniqueLowerCaseFields.get(lfname);
        if (ff != null) {
            throw new AmbiguousVarException(fname, ff);
        }
        return this.searchFieldFromSuperClass(fname, strictMatch);
    }

    private IOpenField searchFieldFromSuperClass(String fname, boolean strictMatch) {
        Iterator<IOpenClass> superClasses = this.superClasses();
        while (superClasses.hasNext()) {
            IOpenField f = superClasses.next().getField(fname, strictMatch);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    @Override
    public IOpenField getIndexField() {
        return this.indexField;
    }

    @Override
    public IOpenMethod getMatchingMethod(String name, IOpenClass[] params) throws AmbiguousMethodException {
        return this.getMethod(name, params);
    }

    @Override
    public IMetaInfo getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public IOpenMethod getMethod(String name, IOpenClass[] classes) {
        MethodKey methodKey;
        Map<MethodKey, IOpenMethod> m = this.methodMap();
        IOpenMethod method = m.get(methodKey = new MethodKey(name, classes));
        if (method == null) {
            Iterator<IOpenClass> superClasses = this.superClasses();
            while (superClasses.hasNext()) {
                method = superClasses.next().getMethod(name, classes);
            }
        }
        if (method != null && this.hasAliasTypeParams(method)) {
            IOpenClass[] methodParams = method.getSignature().getParameterTypes();
            IOpenCast[] typeCasts = new IOpenCast[methodParams.length];
            CastFactory castFactory = new CastFactory();
            for (int i = 0; i < methodParams.length; ++i) {
                IOpenCast castObject;
                IOpenClass methodParam = methodParams[i];
                IOpenClass param = classes[i];
                typeCasts[i] = castObject = castFactory.getCast(param, methodParam);
            }
            CastingMethodCaller methodCaller = new CastingMethodCaller(method, typeCasts);
            method = new MethodDelegator(methodCaller);
        }
        return method;
    }

    private boolean hasAliasTypeParams(IOpenMethod method) {
        IOpenClass[] params;
        for (IOpenClass param : params = method.getSignature().getParameterTypes()) {
            if (!(param instanceof DomainOpenClass)) continue;
            return true;
        }
        return false;
    }

    public String getNameSpace() {
        return "org.openl.this";
    }

    private synchronized Map<String, List<IOpenField>> getNonUniqueLowerCaseFieldMap() {
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.makeLowerCaseMaps();
        }
        return this.nonUniqueLowerCaseFieldMap;
    }

    @Override
    public IOpenClass getOpenClass() {
        return this;
    }

    @Override
    public IOpenSchema getSchema() {
        return this.schema;
    }

    private synchronized Map<String, IOpenField> getUniqueLowerCaseFieldMap() {
        if (this.uniqueLowerCaseFieldMap == null) {
            this.makeLowerCaseMaps();
        }
        return this.uniqueLowerCaseFieldMap;
    }

    @Override
    public IOpenField getVar(String name, boolean strictMatch) {
        return this.getField(name, strictMatch);
    }

    private void initNonUniqueMap() {
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.nonUniqueLowerCaseFieldMap = new HashMap<String, List<IOpenField>>();
        }
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    public boolean isAssignableFrom(IType type) {
        if (type instanceof IOpenClass) {
            return this.isAssignableFrom((IOpenClass)type);
        }
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isArray() {
        if (this.getInstanceClass() != null) {
            return this.getInstanceClass().isArray();
        }
        return false;
    }

    private void makeLowerCaseMaps() {
        this.uniqueLowerCaseFieldMap = new HashMap<String, IOpenField>();
        for (IOpenField field : this.getFields().values()) {
            this.addFieldToLowerCaseMap(field);
        }
        if (this.nonUniqueLowerCaseFieldMap == null) {
            this.nonUniqueLowerCaseFieldMap = Collections.emptyMap();
        }
    }

    protected abstract Map<MethodKey, IOpenMethod> methodMap();

    @Override
    public Iterator<IOpenMethod> methods() {
        List<IOpenMethod> methods = this.getMethods();
        return methods == null ? null : methods.iterator();
    }

    @Override
    public List<IOpenMethod> getMethods() {
        HashMap<MethodKey, IOpenMethod> methods = new HashMap<MethodKey, IOpenMethod>();
        Iterator<IOpenClass> superClasses = this.superClasses();
        while (superClasses.hasNext()) {
            for (IOpenMethod method : superClasses.next().getMethods()) {
                methods.put(new MethodKey(method), method);
            }
        }
        methods.putAll(this.methodMap());
        return new ArrayList<IOpenMethod>(methods.values());
    }

    @Override
    public List<IOpenMethod> getDeclaredMethods() {
        return new ArrayList<IOpenMethod>(this.methodMap().values());
    }

    @Override
    public Object nullObject() {
        return null;
    }

    public void setIndexField(IOpenField field) {
        this.indexField = field;
    }

    @Override
    public void setMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addType(String namespace, IOpenClass type) throws Exception {
    }

    @Override
    public IOpenClass findType(String namespace, String typeName) {
        return null;
    }

    @Override
    public Map<String, IOpenClass> getTypes() {
        return null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IOpenClass)) {
            return false;
        }
        return new EqualsBuilder().append((Object)this.getName(), (Object)((IOpenClass)obj).getName()).isEquals();
    }
}

