/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Array;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;

public class ArrayFieldIndex
implements IOpenIndex {
    private IOpenClass elementType;
    private IOpenField indexField;

    public ArrayFieldIndex(IOpenClass elementType, IOpenField indexField) {
        this.elementType = elementType;
        this.indexField = indexField;
    }

    public IOpenClass getElementType() {
        return this.elementType;
    }

    public IOpenClass getIndexType() {
        return this.indexField.getType();
    }

    public Object getValue(Object container, Object index) {
        if (index != null) {
            int len = Array.getLength(container);
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(container, i);
                Object fieldValue = this.indexField.get(obj, null);
                if (index instanceof String && fieldValue instanceof Integer) {
                    index = this.castStringToInteger((String)index);
                }
                if (!index.equals(fieldValue)) continue;
                return obj;
            }
        }
        return null;
    }

    private Object castStringToInteger(String index) {
        try {
            return Integer.valueOf(index);
        }
        catch (NumberFormatException numberFormatException) {
            return index;
        }
    }

    public boolean isWritable() {
        return false;
    }

    public void setValue(Object container, Object index, Object value) {
        throw new UnsupportedOperationException();
    }
}

