/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.HashMap;
import java.util.Map;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArrayOpenClass
extends AOpenClass {
    protected IOpenClass componentClass;
    protected HashMap<String, IOpenField> fieldMap;
    protected Map<MethodKey, IOpenMethod> methodMap = new HashMap<MethodKey, IOpenMethod>();
    protected IOpenIndex index;

    public ArrayOpenClass(IOpenSchema schema, IOpenClass componentClass, IOpenField lengthOpenField) {
        super(schema);
        this.componentClass = componentClass;
        this.fieldMap = new HashMap(1);
        this.fieldMap.put(lengthOpenField.getName(), lengthOpenField);
    }

    @Override
    protected Map<String, IOpenField> fieldMap() {
        return this.fieldMap;
    }

    public IOpenClass getComponentClass() {
        return this.componentClass;
    }

    public String getDisplayName(int mode) {
        return this.componentClass.getDisplayName(mode) + "[]";
    }

    @Override
    public Class<?> getInstanceClass() {
        if (this.componentClass.getInstanceClass() != null) {
            return JavaOpenClass.makeArrayClass(this.componentClass.getInstanceClass());
        }
        return null;
    }

    public String getName() {
        return this.componentClass.getName() + "[]";
    }

    @Override
    protected Map<MethodKey, IOpenMethod> methodMap() {
        return this.methodMap;
    }

    @Override
    public boolean isArray() {
        return true;
    }
}

