/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.exception.OpenLRuntimeException;
import org.openl.types.IOpenClass;
import org.openl.types.impl.AOpenField;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;

public class DatatypeOpenField
extends AOpenField {
    private final Log LOG = LogFactory.getLog(DatatypeOpenField.class);
    private IOpenClass declaringClass;

    public DatatypeOpenField(IOpenClass declaringClass, String name, IOpenClass type) {
        super(name, type);
        this.declaringClass = declaringClass;
    }

    public DatatypeOpenField(String name, IOpenClass type) {
        super(name, type);
    }

    public Object get(Object target, IRuntimeEnv env) {
        if (target == null) {
            throw new OpenLRuntimeException(String.format("Can not get [%s] field from \"null\" object", this.getName()));
        }
        Object res = null;
        Class<?> targetClass = target.getClass();
        try {
            try {
                Method method = targetClass.getMethod(StringTool.getGetterName((String)this.getName()), new Class[0]);
                res = method.invoke(target, new Object[0]);
            }
            catch (NoSuchMethodException e1) {
                this.LOG.error((Object)this, (Throwable)e1);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
        }
        catch (SecurityException e) {
            this.LOG.error((Object)this, (Throwable)e);
        }
        return res != null ? res : this.getType().nullObject();
    }

    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isWritable() {
        return true;
    }

    public void set(Object target, Object value, IRuntimeEnv env) {
        Class<?> targetClass = target.getClass();
        try {
            try {
                Method method = targetClass.getMethod(StringTool.getSetterName((String)this.getName()), this.getType().getInstanceClass());
                method.invoke(target, value);
            }
            catch (NoSuchMethodException e1) {
                this.LOG.error((Object)this, (Throwable)e1);
            }
            catch (IllegalArgumentException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.LOG.error((Object)this, (Throwable)e);
            }
        }
        catch (SecurityException e) {
            this.LOG.error((Object)this, (Throwable)e);
        }
    }

    public void setDeclaringClass(IOpenClass declaringClass) {
        this.declaringClass = declaringClass;
    }
}

