/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.AAggregateInfo;
import org.openl.types.impl.ADynamicClass;
import org.openl.types.impl.ArrayFieldIndex;
import org.openl.types.impl.ArrayIndex;
import org.openl.types.impl.ArrayLengthOpenField;
import org.openl.types.impl.ArrayOpenClass;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.AOpenIterator;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicArrayAggregateInfo
extends AAggregateInfo {
    public static final DynamicArrayAggregateInfo aggregateInfo = new DynamicArrayAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        if (aggregateType instanceof ArrayOpenClass) {
            return ((ArrayOpenClass)aggregateType).getComponentClass();
        }
        return null;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (indexType == JavaOpenClass.INT) {
            return new ArrayIndex(this.getComponentType(aggregateType));
        }
        IOpenClass componentClass = ((ArrayOpenClass)aggregateType).getComponentClass();
        IOpenField indexField = componentClass.getIndexField();
        if (indexField != null) {
            if (indexField.getType() == indexType) {
                return new ArrayFieldIndex(componentClass, indexField);
            }
            if (indexField.getType() == JavaOpenClass.INT && String.class.equals(indexType.getInstanceClass())) {
                return new ArrayFieldIndex(componentClass, indexField);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOpenClass getIndexedAggregateType(IOpenClass componentType, int dim) {
        IOpenClass[] arrayTypes;
        if (dim == 0) {
            return componentType;
        }
        IOpenClass[] iOpenClassArray = arrayTypes = ((ADynamicClass)componentType).getArrayTypes();
        synchronized (arrayTypes) {
            if (arrayTypes[dim - 1] != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return arrayTypes[dim - 1];
            }
            for (int i = 0; i < dim; ++i) {
                componentType = new MyArrayOpenClass(componentType);
            }
            IOpenClass iOpenClass = componentType;
            arrayTypes[dim - 1] = iOpenClass;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return iOpenClass;
        }
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return null;
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return type instanceof ArrayOpenClass;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyArrayOpenClass
    extends ArrayOpenClass {
        public MyArrayOpenClass(IOpenClass componentClass) {
            super(componentClass.getSchema(), componentClass, new MyArrayLengthOpenField());
        }

        @Override
        public IAggregateInfo getAggregateInfo() {
            return aggregateInfo;
        }

        @Override
        public boolean isAssignableFrom(Class<?> c) {
            return false;
        }

        @Override
        public boolean isAssignableFrom(IOpenClass ioc) {
            return false;
        }

        @Override
        public boolean isInstance(Object instance) {
            return false;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            return null;
        }

        @Override
        public Iterator<IOpenClass> superClasses() {
            return AOpenIterator.empty();
        }
    }

    static class MyArrayLengthOpenField
    extends ArrayLengthOpenField {
        MyArrayLengthOpenField() {
        }

        public int getLength(Object target) {
            return Array.getLength(target);
        }
    }
}

