/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import java.util.HashMap;
import java.util.Map;
import org.openl.types.IDynamicObject;
import org.openl.types.IOpenClass;
import org.openl.util.print.NicePrinter;
import org.openl.util.print.NicePrinterAdaptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicObject
implements IDynamicObject {
    private IOpenClass type;
    private HashMap<String, Object> fieldValues = new HashMap();

    public static NicePrinterAdaptor getNicePrinterAdaptor() {
        return new DONIcePrinterAdaptor();
    }

    public DynamicObject() {
    }

    public DynamicObject(IOpenClass type) {
        this.type = type;
    }

    public boolean containsField(String name) {
        return this.fieldValues.containsKey(name);
    }

    @Override
    public Object getFieldValue(String name) {
        return this.fieldValues.get(name);
    }

    @Override
    public Map<String, Object> getFieldValues() {
        return (HashMap)this.fieldValues.clone();
    }

    @Override
    public IOpenClass getType() {
        return this.type;
    }

    protected boolean isMyField(String name) {
        return this.type.getField(name) != null;
    }

    @Override
    public void setFieldValue(String name, Object value) {
        this.fieldValues.put(name, value);
    }

    public void setType(IOpenClass type) {
        this.type = type;
    }

    public String toString() {
        NicePrinter printer = new NicePrinter();
        printer.print((Object)this, DynamicObject.getNicePrinterAdaptor());
        return printer.getBuffer().toString();
    }

    private static class DONIcePrinterAdaptor
    extends NicePrinterAdaptor {
        private DONIcePrinterAdaptor() {
        }

        protected String getTypeName(Object obj) {
            if (obj instanceof DynamicObject) {
                return ((DynamicObject)obj).getType().getName();
            }
            return super.getTypeName(obj);
        }

        public void printObject(Object obj, int newID, NicePrinter printer) {
            if (obj instanceof IDynamicObject) {
                IDynamicObject dobj = (IDynamicObject)obj;
                this.printReference(dobj, newID, printer);
                this.printMap(dobj.getFieldValues(), null, printer);
                return;
            }
            super.printObject(obj, newID, printer);
        }
    }
}

