/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

public final class MethodKey {
    private String name;
    private IOpenClass[] pars;
    private IOpenClass[] internalParameters;

    public MethodKey(IOpenMethod om) {
        this.name = om.getName();
        this.pars = om.getSignature().getParameterTypes();
        this.internalParameters = this.getNormalizedParams(this.pars);
    }

    public MethodKey(String name, IOpenClass[] pars) {
        this.name = name;
        this.pars = pars;
        this.internalParameters = this.getNormalizedParams(pars);
    }

    private IOpenClass[] getNormalizedParams(IOpenClass[] originalParams) {
        if (originalParams == null) {
            return null;
        }
        IOpenClass[] normalizedParams = new IOpenClass[originalParams.length];
        for (int i = 0; i < originalParams.length; ++i) {
            IOpenClass param;
            IOpenClass normParam = param = originalParams[i];
            if (param instanceof DomainOpenClass) {
                normParam = JavaOpenClass.getOpenClass(param.getInstanceClass());
            }
            normalizedParams[i] = normParam;
        }
        return normalizedParams;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey mk = (MethodKey)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)mk.name).append((Object[])this.internalParameters, (Object[])mk.internalParameters).isEquals();
    }

    public int hashCode() {
        int hashCode = new HashCodeBuilder().append((Object)this.name).append((Object[])this.internalParameters).toHashCode();
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append("(");
        boolean first = true;
        for (IOpenClass c : this.pars) {
            if (!first) {
                sb.append(",");
            }
            sb.append(c.getName());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

