/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IParameterDeclaration;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.util.ArrayTool;

public class MethodSignature
implements IMethodSignature {
    IParameterDeclaration[] parameters;

    public MethodSignature(IMethodSignature ims) {
        IOpenClass[] parTypes = ims.getParameterTypes();
        int len = parTypes.length;
        this.parameters = new IParameterDeclaration[len];
        for (int i = 0; i < len; ++i) {
            this.parameters[i] = new ParameterDeclaration(parTypes[i], ims.getParameterName(i));
        }
    }

    public MethodSignature(IOpenClass[] parTypes) {
        int len = parTypes.length;
        this.parameters = new IParameterDeclaration[len];
        for (int i = 0; i < len; ++i) {
            this.parameters[i] = new ParameterDeclaration(parTypes[i], "p" + i);
        }
    }

    public MethodSignature(IOpenClass[] parTypes, String[] names) {
        int len = parTypes.length;
        this.parameters = new IParameterDeclaration[len];
        for (int i = 0; i < len; ++i) {
            this.parameters[i] = new ParameterDeclaration(parTypes[i], names[i]);
        }
    }

    public MethodSignature(IParameterDeclaration[] parameters) {
        this.parameters = parameters;
    }

    public int getNumberOfParameters() {
        return this.parameters.length;
    }

    public int getParameterDirection(int i) {
        return this.parameters[i].getDirection();
    }

    public String getParameterName(int i) {
        return this.parameters[i].getName();
    }

    public IOpenClass getParameterType(int i) {
        return this.parameters[i].getType();
    }

    public IOpenClass[] getParameterTypes() {
        IOpenClass[] parameterTypes = new IOpenClass[this.parameters.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = this.parameters[i].getType();
        }
        return parameterTypes;
    }

    public MethodSignature merge(IParameterDeclaration[] extraParams) {
        return new MethodSignature((IParameterDeclaration[])ArrayTool.merge((Object)this.parameters, (Object)extraParams));
    }
}

