/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.impl;

import org.openl.binding.MethodUtil;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;

public class OpenMethodHeader
implements IOpenMethodHeader {
    protected IMethodSignature signature;
    protected IOpenClass declaringClass;
    protected IOpenClass typeClass;
    protected String name;
    protected boolean isStatic;
    protected IMemberMetaInfo info;

    public OpenMethodHeader(String name, IOpenClass typeClass, IMethodSignature signature, IOpenClass declaringClass) {
        this(name, typeClass, signature, declaringClass, false, null);
    }

    public OpenMethodHeader(String name, IOpenClass typeClass, IMethodSignature signature, IOpenClass declaringClass, boolean isStatic, IMemberMetaInfo info) {
        this.name = name;
        this.typeClass = typeClass;
        this.signature = signature;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.info = info;
    }

    public IOpenClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDisplayName(int mode) {
        return MethodUtil.printMethod(this, mode, false);
    }

    public IMemberMetaInfo getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public IMethodSignature getSignature() {
        return this.signature;
    }

    public IOpenClass getType() {
        return this.typeClass;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setDeclaringClass(IOpenClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    public void setTypeClass(IOpenClass typeClass) {
        this.typeClass = typeClass;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getType().getName()).append(' ');
        MethodUtil.printMethod(this.getName(), this.getSignature(), buf);
        return buf.toString();
    }
}

