/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ArrayTool;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanOpenField
implements IOpenField {
    PropertyDescriptor descriptor;

    public static void collectFields(Map<String, IOpenField> map, Class<?> c, Map<Method, BeanOpenField> getters, Map<Method, BeanOpenField> setters) {
        if (c.isInterface()) {
            Class<?>[] interfaces = c.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                BeanOpenField.collectFields(map, interfaces[i], getters, setters);
            }
        }
        try {
            BeanInfo info = Introspector.getBeanInfo(c);
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                if (pd[i].getPropertyType() == null || pd[i].getName().equals("class")) continue;
                BeanOpenField bf = new BeanOpenField(pd[i]);
                map.put(pd[i].getName(), bf);
                if (getters != null && pd[i].getReadMethod() != null) {
                    getters.put(pd[i].getReadMethod(), bf);
                }
                if (setters == null || pd[i].getWriteMethod() == null) continue;
                setters.put(pd[i].getWriteMethod(), bf);
            }
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public BeanOpenField(PropertyDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public Object get(Object target, IRuntimeEnv env) {
        try {
            return this.descriptor.getReadMethod().invoke(target, ArrayTool.ZERO_OBJECT);
        }
        catch (Exception ex) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)ex);
        }
    }

    @Override
    public IOpenClass getDeclaringClass() {
        if (this.descriptor.getReadMethod() != null) {
            return JavaOpenClass.getOpenClass(this.descriptor.getReadMethod().getDeclaringClass());
        }
        if (this.descriptor.getWriteMethod() != null) {
            return JavaOpenClass.getOpenClass(this.descriptor.getWriteMethod().getDeclaringClass());
        }
        throw new RuntimeException("Something is wrong with this bean");
    }

    public String getDisplayName(int mode) {
        return this.getName();
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return null;
    }

    public String getName() {
        return this.descriptor.getName();
    }

    @Override
    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.descriptor.getPropertyType());
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isReadable() {
        return this.descriptor.getReadMethod() != null;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return this.descriptor.getWriteMethod() != null;
    }

    @Override
    public void set(Object target, Object value, IRuntimeEnv env) {
        try {
            this.descriptor.getWriteMethod().invoke(target, value);
        }
        catch (Exception ex) {
            throw RuntimeExceptionWrapper.wrap((String)"", (Throwable)ex);
        }
    }

    public String toString() {
        return this.getName();
    }
}

