/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Iterator;
import java.util.List;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;
import org.openl.types.impl.AAggregateInfo;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.OpenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaListAggregateInfo
extends AAggregateInfo {
    public static final IAggregateInfo LIST_AGGREGATE = new JavaListAggregateInfo();

    @Override
    public IOpenClass getComponentType(IOpenClass aggregateType) {
        return JavaOpenClass.OBJECT;
    }

    @Override
    public IOpenIndex getIndex(IOpenClass aggregateType, IOpenClass indexType) {
        if (indexType != JavaOpenClass.INT) {
            return null;
        }
        if (!this.isAggregate(aggregateType)) {
            return null;
        }
        return this.makeListIndex(aggregateType);
    }

    @Override
    public Iterator<Object> getIterator(Object aggregate) {
        return OpenIterator.fromArrayObj((Object)aggregate);
    }

    @Override
    public boolean isAggregate(IOpenClass type) {
        return true;
    }

    private IOpenIndex makeListIndex(IOpenClass aggregateType) {
        return new ListIndex(this.getComponentType(aggregateType));
    }

    static class ListIndex
    implements IOpenIndex {
        IOpenClass elementType;

        public ListIndex(IOpenClass elementType) {
            this.elementType = elementType;
        }

        public IOpenClass getElementType() {
            return this.elementType;
        }

        public IOpenClass getIndexType() {
            return JavaOpenClass.INT;
        }

        public Object getValue(Object container, Object index) {
            return ((List)container).get((Integer)index);
        }

        public boolean isWritable() {
            return true;
        }

        public void setValue(Object container, Object index, Object value) {
            ((List)container).set((Integer)index, value);
        }
    }
}

