/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openl.binding.exception.AmbiguousMethodException;
import org.openl.types.IAggregateInfo;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethod;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.AOpenClass;
import org.openl.types.impl.ArrayIndex;
import org.openl.types.impl.ArrayLengthOpenField;
import org.openl.types.impl.MethodKey;
import org.openl.types.java.BeanOpenField;
import org.openl.types.java.JavaArrayAggregateInfo;
import org.openl.types.java.JavaListAggregateInfo;
import org.openl.types.java.JavaOpenConstructor;
import org.openl.types.java.JavaOpenEnum;
import org.openl.types.java.JavaOpenField;
import org.openl.types.java.JavaOpenMethod;
import org.openl.util.AOpenIterator;
import org.openl.util.CollectionsUtil;
import org.openl.util.IConvertor;
import org.openl.util.IOpenIterator;
import org.openl.util.OpenIterator;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.util.StringTool;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOpenClass
extends AOpenClass {
    public static final IConvertor<Class, IOpenClass> Class2JavaOpenClass = new Class2JavaOpenClassCollector();
    private static Map<Class<?>, IOpenClass> javaClassCache = null;
    public static final JavaOpenClass INT = new JavaPrimitiveClass(Integer.TYPE, Integer.class, new Integer(0));
    public static final JavaOpenClass LONG = new JavaPrimitiveClass(Long.TYPE, Long.class, new Long(0L));
    public static final JavaOpenClass DOUBLE = new JavaPrimitiveClass(Double.TYPE, Double.class, new Double(0.0));
    public static final JavaOpenClass FLOAT = new JavaPrimitiveClass(Float.TYPE, Float.class, new Float(0.0f));
    public static final JavaOpenClass SHORT = new JavaPrimitiveClass(Short.TYPE, Short.class, new Short(0));
    public static final JavaOpenClass CHAR = new JavaPrimitiveClass(Character.TYPE, Character.class, new Character('\u0000'));
    public static final JavaOpenClass BYTE = new JavaPrimitiveClass(Byte.TYPE, Byte.class, new Byte(0));
    public static final JavaOpenClass BOOLEAN = new JavaPrimitiveClass(Boolean.TYPE, Boolean.class, Boolean.FALSE);
    public static final JavaOpenClass VOID = new JavaPrimitiveClass(Void.TYPE, Void.class, null);
    public static final JavaOpenClass STRING = new JavaOpenClass(String.class, null, true);
    public static final JavaOpenClass OBJECT = new JavaOpenClass(Object.class, null, true);
    public static final JavaOpenClass CLASS = new JavaOpenClass(Class.class, null, true);
    protected Class<?> instanceClass;
    private boolean simple = false;
    private IAggregateInfo aggregateInfo;
    protected HashMap<String, IOpenField> fields = null;
    protected HashMap<MethodKey, IOpenMethod> methods = null;

    protected static synchronized Map<Class<?>, IOpenClass> getJavaClassCache() {
        if (javaClassCache == null) {
            javaClassCache = new HashMap();
            javaClassCache.put(Integer.TYPE, INT);
            javaClassCache.put(Long.TYPE, LONG);
            javaClassCache.put(Double.TYPE, DOUBLE);
            javaClassCache.put(Float.TYPE, FLOAT);
            javaClassCache.put(Short.TYPE, SHORT);
            javaClassCache.put(Character.TYPE, CHAR);
            javaClassCache.put(Byte.TYPE, BYTE);
            javaClassCache.put(Boolean.TYPE, BOOLEAN);
            javaClassCache.put(Void.TYPE, VOID);
            javaClassCache.put(String.class, STRING);
            javaClassCache.put(Object.class, OBJECT);
            javaClassCache.put(Class.class, CLASS);
        }
        return javaClassCache;
    }

    protected JavaOpenClass(Class<?> instanceClass, IOpenSchema schema) {
        super(schema);
        this.instanceClass = instanceClass;
        this.schema = schema;
    }

    protected JavaOpenClass(Class<?> instanceClass, IOpenSchema schema, boolean simple) {
        super(schema);
        this.instanceClass = instanceClass;
        this.schema = schema;
        this.simple = simple;
    }

    public static synchronized JavaOpenClass getOpenClass(Class<?> c) {
        JavaOpenClass res = (JavaOpenClass)JavaOpenClass.getJavaClassCache().get(c);
        if (res == null) {
            res = c.isInterface() ? new JavaOpenInterface(c, null) : (c.isEnum() ? new JavaOpenEnum(c, null) : new JavaOpenClass(c, null));
            JavaOpenClass.getJavaClassCache().put(c, res);
        }
        return res;
    }

    public static IOpenClass[] getOpenClasses(Class<?>[] cc) {
        if (cc.length == 0) {
            return IOpenClass.EMPTY;
        }
        Object[] ary = new IOpenClass[cc.length];
        CollectionsUtil.collect((Object[])ary, (Object[])cc, Class2JavaOpenClass);
        return ary;
    }

    public static Class<?> makeArrayClass(Class<?> c) {
        return Array.newInstance(c, 0).getClass();
    }

    public static ArrayIndex makeArrayIndex(IOpenClass arrayType) {
        return new ArrayIndex(JavaOpenClass.getOpenClass(arrayType.getInstanceClass().getComponentType()));
    }

    public static synchronized void printCache() {
        int i = 0;
        for (Class<?> element : JavaOpenClass.getJavaClassCache().keySet()) {
            System.out.println("" + i++ + ":\t" + JavaOpenClass.printClass(element));
        }
    }

    protected static String printClass(Class<?> c) {
        if (c.isArray()) {
            return "[]" + JavaOpenClass.printClass(c.getComponentType());
        }
        return c.getName();
    }

    public static synchronized void resetAllClassloaders(HashMap<?, ClassLoader> oldLoaders) {
        for (ClassLoader cl : oldLoaders.values()) {
            JavaOpenClass.resetClassloader(cl);
        }
    }

    public static synchronized void resetClassloader(ClassLoader cl) {
        ArrayList toRemove = new ArrayList();
        for (Class<Object> c : JavaOpenClass.getJavaClassCache().keySet()) {
            if (c.getClassLoader() != cl) continue;
            toRemove.add(c);
        }
        for (Class<Object> c : toRemove) {
            javaClassCache.remove(c);
        }
    }

    protected void collectBeanFields() {
        BeanOpenField.collectFields(this.fields, this.instanceClass, null, null);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavaOpenClass)) {
            return false;
        }
        return this.instanceClass == ((JavaOpenClass)obj).instanceClass;
    }

    @Override
    protected synchronized Map<String, IOpenField> fieldMap() {
        if (this.fields == null) {
            this.fields = new HashMap();
            Field[] ff = this.instanceClass.getDeclaredFields();
            if (this.isPublic(this.instanceClass)) {
                for (int i = 0; i < ff.length; ++i) {
                    if (!this.isPublic(ff[i])) continue;
                    this.fields.put(ff[i].getName(), new JavaOpenField(ff[i]));
                }
            }
            if (this.instanceClass.isArray()) {
                this.fields.put("length", new JavaArrayLengthField());
            }
            this.fields.put("class", new JavaClassClassField(this.instanceClass));
            this.collectBeanFields();
        }
        return this.fields;
    }

    @Override
    public synchronized IAggregateInfo getAggregateInfo() {
        if (this.aggregateInfo != null) {
            return this.aggregateInfo;
        }
        this.aggregateInfo = List.class.isAssignableFrom(this.getInstanceClass()) ? JavaListAggregateInfo.LIST_AGGREGATE : JavaArrayAggregateInfo.ARRAY_AGGREGATE;
        return this.aggregateInfo;
    }

    public String getDisplayName(int mode) {
        String name = this.getName();
        switch (mode) {
            default: {
                return StringTool.lastToken((String)name, (String)".");
            }
            case 2: 
        }
        return name;
    }

    @Override
    public Class<?> getInstanceClass() {
        return this.instanceClass;
    }

    @Override
    public IOpenMethod getMatchingMethod(String name, IOpenClass[] params) throws AmbiguousMethodException {
        return this.getMethod(name, params);
    }

    public String getName() {
        return this.instanceClass.getName();
    }

    public String getSimpleName() {
        return this.getDisplayName(0);
    }

    @Override
    public int hashCode() {
        return this.instanceClass.hashCode();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.instanceClass.getModifiers());
    }

    @Override
    public boolean isAssignableFrom(Class<?> c) {
        return this.instanceClass.isAssignableFrom(c);
    }

    @Override
    public boolean isAssignableFrom(IOpenClass ioc) {
        return this.instanceClass.isAssignableFrom(ioc.getInstanceClass());
    }

    @Override
    public boolean isInstance(Object instance) {
        return this.instanceClass.isInstance(instance);
    }

    protected boolean isPublic(Class<?> declaringClass) {
        return Modifier.isPublic(declaringClass.getModifiers());
    }

    protected boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    protected synchronized Map<MethodKey, IOpenMethod> methodMap() {
        if (this.methods == null) {
            this.methods = new HashMap();
            Method[] mm = this.instanceClass.getDeclaredMethods();
            if (this.isPublic(this.instanceClass)) {
                for (int i = 0; i < mm.length; ++i) {
                    if (!this.isPublic(mm[i])) continue;
                    JavaOpenMethod om = new JavaOpenMethod(mm[i]);
                    this.methods.put(new MethodKey(om), om);
                }
            }
            Constructor<?>[] cc = this.instanceClass.getDeclaredConstructors();
            for (int i = 0; i < cc.length; ++i) {
                if (!this.isPublic(cc[i])) continue;
                JavaOpenConstructor om = new JavaOpenConstructor(cc[i]);
                this.methods.put(new MethodKey(om), om);
            }
        }
        return this.methods;
    }

    @Override
    public Object newInstance(IRuntimeEnv env) {
        try {
            return this.getInstanceClass().newInstance();
        }
        catch (Exception e) {
            throw RuntimeExceptionWrapper.wrap((Throwable)e);
        }
    }

    @Override
    public Object nullObject() {
        return null;
    }

    @Override
    public Iterator<IOpenClass> superClasses() {
        Object[] tmp = this.instanceClass.getInterfaces();
        IOpenIterator ic = OpenIterator.fromArray((Object[])tmp);
        IOpenIterator interfaces = ic.collect((IConvertor)new Class2JavaOpenClassCollector());
        Class<?> superClass = this.instanceClass.getSuperclass();
        if (superClass == null) {
            return interfaces;
        }
        return AOpenIterator.merge((IOpenIterator)AOpenIterator.single((Object)JavaOpenClass.getOpenClass(superClass)), (IOpenIterator)interfaces);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaOpenInterface
    extends JavaOpenClass {
        private static Method toString;
        private static Method equals;
        private static Method hashCode;
        private HashMap<Method, BeanOpenField> getters;
        private HashMap<Method, BeanOpenField> setters;
        private Class<?> proxyClass;
        private InvocationHandler handler;

        protected JavaOpenInterface(Class<?> instanceClass, IOpenSchema schema) {
            super(instanceClass, schema);
            try {
                toString = Object.class.getMethod("toString", new Class[0]);
                equals = Object.class.getMethod("equals", Object.class);
                hashCode = Object.class.getMethod("hashCode", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw RuntimeExceptionWrapper.wrap((Throwable)nsme);
            }
            this.proxyClass = Proxy.getProxyClass(instanceClass.getClassLoader(), instanceClass);
        }

        @Override
        protected void collectBeanFields() {
            this.getters = new HashMap();
            this.setters = new HashMap();
            BeanOpenField.collectFields(this.fields, this.instanceClass, this.getters, this.setters);
        }

        private synchronized InvocationHandler getInvocationHandler() {
            if (this.handler == null) {
                this.handler = new InterfaceInvocationHandler();
            }
            return this.handler;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            try {
                return Proxy.newProxyInstance(this.instanceClass.getClassLoader(), new Class[]{this.instanceClass}, this.getInvocationHandler());
            }
            catch (Exception e) {
                throw RuntimeExceptionWrapper.wrap((Throwable)e);
            }
        }

        private class InterfaceInvocationHandler
        implements InvocationHandler {
            private IdentityHashMap<Object, HashMap<BeanOpenField, Object>> map = new IdentityHashMap();

            private InterfaceInvocationHandler() {
            }

            public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BeanOpenField bf;
                HashMap<BeanOpenField, Object> values = this.map.get(proxy);
                if (values == null) {
                    values = new HashMap();
                    this.map.put(proxy, values);
                }
                if ((bf = (BeanOpenField)JavaOpenInterface.this.getters.get(method)) != null) {
                    Object res = values.get(bf);
                    return res != null ? res : bf.getType().nullObject();
                }
                bf = (BeanOpenField)JavaOpenInterface.this.setters.get(method);
                if (bf != null) {
                    values.put(bf, args[0]);
                    return null;
                }
                if (method.getName().equals(toString.getName())) {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(proxy));
                }
                if (method.getName().equals(hashCode.getName())) {
                    return System.identityHashCode(proxy);
                }
                if (method.getName().equals(equals.getName())) {
                    return proxy == args[0];
                }
                throw new RuntimeException("Default Interface Proxy Implementation does not support method " + method.getDeclaringClass().getName() + "::" + method.getName() + ". Only bean access is supported");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaPrimitiveClass
    extends JavaOpenClass {
        private Class<?> wrapperClass;
        private Object nullObject;

        public JavaPrimitiveClass(Class<?> instanceClass, Class<?> wrapperClass, Object nullObject) {
            super(instanceClass, null);
            this.wrapperClass = wrapperClass;
            this.nullObject = nullObject;
        }

        @Override
        public boolean isSimple() {
            return true;
        }

        @Override
        public Object newInstance(IRuntimeEnv env) {
            return this.nullObject;
        }

        @Override
        public Object nullObject() {
            return this.nullObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JavaClassClassField
    implements IOpenField {
        private Class<?> instanceClass;

        public JavaClassClassField(Class<?> instanceClass) {
            this.instanceClass = instanceClass;
        }

        @Override
        public Object get(Object target, IRuntimeEnv env) {
            return this.instanceClass;
        }

        @Override
        public IOpenClass getDeclaringClass() {
            return null;
        }

        public String getDisplayName(int mode) {
            return "class";
        }

        @Override
        public IMemberMetaInfo getInfo() {
            return null;
        }

        public String getName() {
            return "class";
        }

        @Override
        public IOpenClass getType() {
            return CLASS;
        }

        @Override
        public boolean isConst() {
            return true;
        }

        @Override
        public boolean isReadable() {
            return true;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        public void set(Object target, Object value, IRuntimeEnv env) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getName();
        }
    }

    private static class JavaArrayLengthField
    extends ArrayLengthOpenField {
        private JavaArrayLengthField() {
        }

        public int getLength(Object target) {
            return Array.getLength(target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Class2JavaOpenClassCollector
    implements IConvertor<Class, IOpenClass> {
        private Class2JavaOpenClassCollector() {
        }

        public IOpenClass convert(Class c) {
            return JavaOpenClass.getOpenClass(c);
        }
    }
}

