/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Constructor;
import org.openl.binding.MethodUtil;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOpenConstructor
implements IOpenMethod,
IMethodSignature {
    private Constructor<?> constructor;
    private IOpenClass[] parameterTypes;

    public JavaOpenConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    @Override
    public IOpenClass getDeclaringClass() {
        return JavaOpenClass.getOpenClass(this.constructor.getDeclaringClass());
    }

    public String getDisplayName(int mode) {
        return MethodUtil.printMethod(this, mode, false);
    }

    @Override
    public IMemberMetaInfo getInfo() {
        return null;
    }

    @Override
    public IOpenMethod getMethod() {
        return this;
    }

    public String getName() {
        return this.getDeclaringClass().getName();
    }

    @Override
    public int getNumberOfParameters() {
        return this.getParameterTypes().length;
    }

    @Override
    public int getParameterDirection(int i) {
        return 0;
    }

    @Override
    public String getParameterName(int i) {
        return "p" + i;
    }

    @Override
    public IOpenClass getParameterType(int i) {
        return this.getParameterTypes()[i];
    }

    @Override
    public synchronized IOpenClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = JavaOpenClass.getOpenClasses(this.constructor.getParameterTypes());
        }
        return this.parameterTypes;
    }

    @Override
    public IMethodSignature getSignature() {
        return this;
    }

    @Override
    public IOpenClass getType() {
        return this.getDeclaringClass();
    }

    @Override
    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        try {
            return this.constructor.newInstance(params);
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    public String toString() {
        return this.getDeclaringClass().getName();
    }
}

