/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openl.binding.MethodUtil;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.RuntimeExceptionWrapper;
import org.openl.vm.IRuntimeEnv;

public class JavaOpenMethod
implements IOpenMethod,
IMethodSignature {
    Method method;
    IOpenClass[] parameterTypes;

    public JavaOpenMethod(Method method) {
        this.method = method;
    }

    public IOpenClass getDeclaringClass() {
        return JavaOpenClass.getOpenClass(this.method.getDeclaringClass());
    }

    public String getDisplayName(int mode) {
        return MethodUtil.printMethod(this, mode, false);
    }

    public IMemberMetaInfo getInfo() {
        return null;
    }

    public IOpenMethod getMethod() {
        return this;
    }

    public String getName() {
        return this.method.getName();
    }

    public int getNumberOfParameters() {
        return this.getParameterTypes().length;
    }

    public int getParameterDirection(int i) {
        return 0;
    }

    public String getParameterName(int i) {
        return null;
    }

    public IOpenClass getParameterType(int i) {
        return this.getParameterTypes()[i];
    }

    public synchronized IOpenClass[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = JavaOpenClass.getOpenClasses(this.method.getParameterTypes());
        }
        return this.parameterTypes;
    }

    public IMethodSignature getSignature() {
        return this;
    }

    public IOpenClass getType() {
        return JavaOpenClass.getOpenClass(this.method.getReturnType());
    }

    public Object invoke(Object target, Object[] params, IRuntimeEnv env) {
        try {
            return this.method.invoke(target, params);
        }
        catch (Throwable t) {
            throw RuntimeExceptionWrapper.wrap((Throwable)t);
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public String toString() {
        return this.getName();
    }
}

