/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.Map;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenSchema;
import org.openl.types.impl.AOpenField;
import org.openl.types.java.JavaOpenClass;
import org.openl.vm.IRuntimeEnv;

public class MapOpenClass
extends JavaOpenClass {
    protected String name;
    protected IOpenClass dynamicFieldType = JavaOpenClass.STRING;

    public MapOpenClass(IOpenSchema schema, String name) {
        super(Map.class, schema);
        this.name = name;
    }

    public synchronized IOpenField getField(String fname, boolean strictMatch) {
        IOpenField f = super.getField(fname, strictMatch);
        if (f == null) {
            f = new MapOpenField(this.name, this.dynamicFieldType);
            this.fieldMap().put(this.name, f);
        }
        return f;
    }

    public String getName() {
        return this.name;
    }

    public static class MapOpenField
    extends AOpenField {
        public MapOpenField(String name, IOpenClass type) {
            super(name, type);
        }

        public Object get(Object target, IRuntimeEnv env) {
            return ((Map)target).get(this.getName());
        }

        public void set(Object target, Object value, IRuntimeEnv env) {
            ((Map)target).put(this.getName(), value);
        }
    }

    public static interface DynamicFieldPolicy {
        public IOpenField getOpenField(String var1);
    }
}

