/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMember;
import org.openl.types.IOpenMethod;
import org.openl.types.impl.DomainOpenClass;
import org.openl.types.java.JavaOpenClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenClassHelper {
    public static synchronized IOpenClass getOpenClass(IOpenClass moduleOpenClass, Class<?> classToFind) {
        IOpenClass result = null;
        if (classToFind != null) {
            Map<String, IOpenClass> internalTypes = moduleOpenClass.getTypes();
            if (classToFind.isArray()) {
                IOpenClass componentType = OpenClassHelper.findType(classToFind.getComponentType(), internalTypes);
                if (componentType != null) {
                    result = componentType.getAggregateInfo().getIndexedAggregateType(componentType, 1);
                }
            } else {
                result = OpenClassHelper.findType(classToFind, internalTypes);
            }
            if (result == null) {
                result = JavaOpenClass.getOpenClass(classToFind);
            }
        }
        return result;
    }

    private static IOpenClass findType(Class<?> classToFind, Map<String, IOpenClass> internalTypes) {
        IOpenClass result = null;
        for (IOpenClass datatypeClass : internalTypes.values()) {
            if (datatypeClass instanceof DomainOpenClass || !classToFind.equals(datatypeClass.getInstanceClass())) continue;
            result = datatypeClass;
            break;
        }
        return result;
    }

    public static synchronized IOpenClass[] getOpenClasses(IOpenClass moduleOpenClass, Class<?>[] classesToFind) {
        ArrayList<IOpenClass> openClassList = new ArrayList<IOpenClass>();
        if (classesToFind.length == 0) {
            return IOpenClass.EMPTY;
        }
        for (Class<?> classToFind : classesToFind) {
            openClassList.add(OpenClassHelper.getOpenClass(moduleOpenClass, classToFind));
        }
        return openClassList.toArray(new IOpenClass[openClassList.size()]);
    }

    public static IOpenMember[] getClassMembers(IOpenClass openClass) {
        ArrayList members = new ArrayList();
        if (openClass != null) {
            List<IOpenMethod> methods = openClass.getMethods();
            CollectionUtils.addAll(members, methods.iterator());
            Collection<IOpenField> fields = openClass.getFields().values();
            CollectionUtils.addAll(members, fields.iterator());
        }
        return members.toArray(new IOpenMember[members.size()]);
    }

    public static Class<?>[] getInstanceClasses(IOpenClass[] openClasses) {
        ArrayList classes = new ArrayList();
        if (openClasses != null) {
            for (IOpenClass openClass : openClasses) {
                Class<?> clazz = openClass.getInstanceClass();
                classes.add(clazz);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static boolean isBooleanType(IOpenClass type) {
        return type == null || JavaOpenClass.BOOLEAN == type || JavaOpenClass.getOpenClass(Boolean.class) == type;
    }
}

