/*
 * Decompiled with CFR 0.152.
 */
package org.openl.util.text;

import java.util.ArrayList;
import java.util.Arrays;

public class TextInfo {
    String text;
    int[] lineTable;

    public static int getColumn(String line, int linePos, int tabsize) {
        int col = 0;
        for (int i = 0; i < linePos; ++i) {
            if (line.charAt(i) == '\t') {
                col += tabsize - col % tabsize;
                continue;
            }
            ++col;
        }
        return col;
    }

    public static int getPosition(String line, int column, int tabsize) {
        if (column == 0) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i < line.length(); ++i) {
            pos = line.charAt(i) == '\t' ? (pos += tabsize - pos % tabsize) : ++pos;
            if (pos < column) continue;
            return i + 1;
        }
        throw new RuntimeException();
    }

    public TextInfo(String text) {
        this.text = text;
    }

    public String getLine(int i) {
        int from = this.lines()[i];
        int to = i + 1 >= this.lines().length ? this.text.length() : this.lines()[i + 1];
        return this.text.substring(from, to);
    }

    public int getLineIdx(int absPosition) {
        int idx = Arrays.binarySearch(this.lines(), absPosition);
        if (idx >= 0) {
            return idx;
        }
        return -idx - 1 - 1;
    }

    public int getPosition(int line) {
        return this.lines()[line];
    }

    private int[] lines() {
        if (this.lineTable == null) {
            this.scanText();
        }
        return this.lineTable;
    }

    protected void scanText() {
        int i;
        boolean isCR = false;
        boolean isLF = true;
        ArrayList<Integer> table = new ArrayList<Integer>();
        for (i = 0; i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (isLF) {
                isLF = false;
                table.add(new Integer(i));
            } else if (isCR) {
                isCR = false;
                if (c != '\n') {
                    table.add(new Integer(i));
                }
            }
            if (c == '\n') {
                isLF = true;
                continue;
            }
            if (c != '\r') continue;
            isCR = true;
        }
        if (isLF || isCR) {
            table.add(new Integer(this.text.length()));
        }
        this.lineTable = new int[table.size()];
        for (i = 0; i < this.lineTable.length; ++i) {
            this.lineTable[i] = (Integer)table.get(i);
        }
    }
}

