/*
 * Decompiled with CFR 0.152.
 */
package org.openl.vm;

import org.openl.IOpenDebugger;
import org.openl.IOpenRunner;
import org.openl.IOpenVM;
import org.openl.binding.IBoundMethodNode;
import org.openl.exception.OpenLRuntimeException;
import org.openl.runtime.IRuntimeContext;
import org.openl.util.fast.FastStack;
import org.openl.vm.IRuntimeEnv;

public class SimpleVM
implements IOpenVM {
    public IOpenDebugger getDebugger() {
        return null;
    }

    public IOpenRunner getRunner() {
        return new SimpleRunner();
    }

    public IRuntimeEnv getRuntimeEnv() {
        return new SimpleRuntimeEnv();
    }

    static class SimpleRuntimeEnv
    implements IRuntimeEnv {
        IOpenRunner runner;
        FastStack thisStack = new FastStack(100);
        FastStack frameStack = new FastStack(100);
        private IRuntimeContext context;

        SimpleRuntimeEnv() {
            this(new SimpleRunner(), 0, new Object[0]);
        }

        SimpleRuntimeEnv(IOpenRunner runner, int frameSize, Object[] params) {
            Object[] aLocalFrame = new Object[frameSize];
            this.runner = runner;
            System.arraycopy(params, 0, aLocalFrame, 0, params.length);
            this.pushLocalFrame(aLocalFrame);
        }

        public Object[] getLocalFrame() {
            return (Object[])this.frameStack.peek();
        }

        public IOpenRunner getRunner() {
            return this.runner;
        }

        public Object getThis() {
            if (this.thisStack.size() == 0) {
                return null;
            }
            return this.thisStack.peek();
        }

        public Object[] popLocalFrame() {
            return (Object[])this.frameStack.pop();
        }

        public Object popThis() {
            return this.thisStack.pop();
        }

        public void pushLocalFrame(Object[] frame) {
            this.frameStack.push((Object)frame);
        }

        public void pushThis(Object thisObject) {
            this.thisStack.push(thisObject);
        }

        public IRuntimeContext getContext() {
            return this.context;
        }

        public void setContext(IRuntimeContext context) {
            this.context = context;
        }
    }

    static class SimpleRunner
    implements IOpenRunner {
        SimpleRunner() {
        }

        public Object run(IBoundMethodNode node, Object[] params) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            return node.evaluate(new SimpleRuntimeEnv(this, frameSize, params));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(IBoundMethodNode node, Object[] params, IRuntimeEnv env) throws OpenLRuntimeException {
            int frameSize = node.getLocalFrameSize();
            Object[] frame = new Object[frameSize];
            if (params != null && params.length > 0) {
                System.arraycopy(params, 0, frame, 0, params.length);
            }
            try {
                env.pushLocalFrame(frame);
                Object object = node.evaluate(env);
                return object;
            }
            finally {
                env.popLocalFrame();
            }
        }
    }
}

