/*
 * Decompiled with CFR 0.152.
 */
package org.openl.vm.trace;

import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.TraceFormatter;

public class RawStringTraceFormatter
implements TraceFormatter {
    public String format(ITracerObject[] tracerObjects) {
        StringBuffer buffer = new StringBuffer();
        for (ITracerObject tracerObject : tracerObjects) {
            buffer.append(this.print(tracerObject, 0));
        }
        return buffer.toString();
    }

    private String print(ITracerObject tracerObject, int level) {
        ITracerObject[] children;
        StringBuffer buffer = new StringBuffer();
        String indent = this.getIndent(level);
        buffer.append(indent);
        buffer.append("TRACE: " + tracerObject.getDisplayName(1));
        buffer.append("\n");
        buffer.append(indent);
        buffer.append("    at " + tracerObject.getUri() + "&" + "openl" + "=");
        for (ITracerObject child : children = tracerObject.getTracerObjects()) {
            buffer.append("\n");
            buffer.append(this.print(child, level + 1));
        }
        return buffer.toString() + "\n";
    }

    private String getIndent(int level) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }
}

