/*
 * Decompiled with CFR 0.152.
 */
package org.openl.vm.trace;

import java.util.Stack;
import org.openl.vm.trace.ITracerObject;
import org.openl.vm.trace.SimpleTracerObject;

public class Tracer {
    private static ThreadLocal<Tracer> tracer = new ThreadLocal();
    private Stack<ITracerObject> stack = new Stack();
    private ITracerObject root;

    public Tracer() {
        this.init();
    }

    public static Tracer getTracer() {
        return tracer.get();
    }

    public static boolean isTracerOn() {
        return tracer.get() != null;
    }

    public static void setTracer(Tracer t) {
        tracer.set(t);
    }

    public ITracerObject getRoot() {
        return this.root;
    }

    public void setRoot(ITracerObject root) {
        this.root = root;
    }

    public ITracerObject[] getTracerObjects() {
        return this.root.getTracerObjects();
    }

    private void init() {
        this.root = new SimpleTracerObject(){

            public String getDisplayName(int mode) {
                return "Trace";
            }

            public String getType() {
                return "traceroot";
            }

            public String getUri() {
                return null;
            }
        };
    }

    private void addTracerObject(ITracerObject to) {
        this.root.addChild(to);
    }

    public void pop() {
        this.stack.pop();
    }

    public void push(ITracerObject obj) {
        if (this.stack.size() == 0) {
            this.addTracerObject(obj);
        } else {
            ITracerObject to = this.stack.peek();
            to.addChild(obj);
            obj.setParent(to);
        }
        this.stack.push(obj);
    }

    public void reset() {
        this.init();
    }
}

