/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.factories;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.config.ConfigProperty;
import org.openl.config.ConfigPropertyString;
import org.openl.config.ConfigSet;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.RRepositoryFactory;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrRepository;
import org.xml.sax.InputSource;

public abstract class AbstractJcrRepositoryFactory
implements RRepositoryFactory {
    private static final Log log = LogFactory.getLog(AbstractJcrRepositoryFactory.class);
    public static final String DEFAULT_NODETYPE_FILE = "/org/openl/rules/repository/openl_nodetypes.xml";
    private final ConfigPropertyString confRulesProjectsLocation = new ConfigPropertyString("repository.rules.path", "/rules");
    private final ConfigPropertyString confDeploymentProjectsLocation = new ConfigPropertyString("repository.deployments.path", "/deployments");
    private Repository repository;
    protected String repositoryName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOnStart() throws RepositoryException {
        Session systemSession = null;
        try {
            systemSession = this.createSession("sys", "secret");
            NodeTypeManager ntm = systemSession.getWorkspace().getNodeTypeManager();
            boolean initNodeTypes = false;
            try {
                ntm.getNodeType("openl:project");
            }
            catch (NoSuchNodeTypeException e) {
                initNodeTypes = true;
            }
            if (initNodeTypes) {
                this.initNodeTypes(ntm);
            } else {
                this.checkSchemaVersion(ntm);
            }
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    protected void checkSchemaVersion(NodeTypeManager ntm) throws RepositoryException {
        PropertyDefinition[] propDefs;
        String schemaVersion = null;
        NodeType nodeType = null;
        try {
            nodeType = ntm.getNodeType("openl:repository");
        }
        catch (NoSuchNodeTypeException e) {
            throw new RepositoryException("Cannot determine scheme version: " + e.getMessage());
        }
        for (PropertyDefinition definition : propDefs = nodeType.getPropertyDefinitions()) {
            if (!"schema-version".equals(definition.getName())) continue;
            Value[] defValues = definition.getDefaultValues();
            if (defValues == null || defValues.length <= 0) break;
            schemaVersion = defValues[0].getString();
            break;
        }
        if (schemaVersion == null) {
            throw new RepositoryException("Cannot determine scheme version: no special property or value!");
        }
        String expectedVersion = this.getExpectedSchemaVersion();
        if (!expectedVersion.equals(schemaVersion)) {
            throw new RepositoryException("Schema version is different. Has (" + schemaVersion + ") when (" + expectedVersion + ") expected.");
        }
    }

    protected Session createSession(String user, String pass) throws RepositoryException {
        char[] password = pass.toCharArray();
        SimpleCredentials sc = new SimpleCredentials(user, password);
        Session session = this.repository.login((Credentials)sc);
        return session;
    }

    private String getExpectedSchemaVersion() throws RepositoryException {
        String xPathQ = "/nodeTypes/nodeType[@name = 'openl:repository']/propertyDefinition[@name = 'schema-version']/defaultValues/defaultValue[1]";
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        String file = DEFAULT_NODETYPE_FILE;
        try {
            InputSource source = new InputSource(this.getClass().getResourceAsStream(file));
            String result = xPath.evaluate(xPathQ, source);
            if (result == null || result.length() == 0) {
                throw new Exception("Cannot find node.");
            }
            return result;
        }
        catch (Exception e) {
            throw new RepositoryException("Cannot read schema version from '" + file + "': " + e.getMessage());
        }
    }

    public RRepository getRepositoryInstance() throws RRepositoryException {
        try {
            Session session = this.createSession("user", "pass");
            JcrRepository jri = new JcrRepository(this.repositoryName, session, (String)this.confRulesProjectsLocation.getValue(), (String)this.confDeploymentProjectsLocation.getValue());
            return jri;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get Repository Instance", (Throwable)e);
        }
    }

    public void initialize(ConfigSet confSet) throws RRepositoryException {
        confSet.updateProperty((ConfigProperty)this.confRulesProjectsLocation);
        confSet.updateProperty((ConfigProperty)this.confDeploymentProjectsLocation);
    }

    protected abstract void initNodeTypes(NodeTypeManager var1) throws RepositoryException;

    public void release() throws RRepositoryException {
    }

    protected void setRepository(Repository rep, String name) throws RepositoryException {
        this.repository = rep;
        this.repositoryName = name;
        this.checkOnStart();
    }
}

