/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrVersion;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrCommonArtefact {
    private static final Log log = LogFactory.getLog(JcrCommonArtefact.class);
    private String name;
    private Node node;

    protected JcrCommonArtefact(Node node) throws RepositoryException {
        this.node = node;
        this.name = node.getName();
    }

    public void delete() throws RRepositoryException {
        try {
            Node n = this.node();
            NodeUtil.smartCheckout(n, true);
            n.remove();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Delete.", (Throwable)e);
        }
    }

    public RVersion getActiveVersion() {
        try {
            Version v = this.node().getBaseVersion();
            JcrVersion result = new JcrVersion(v);
            return result;
        }
        catch (RepositoryException e) {
            log.info((Object)"getActiveVersion", (Throwable)e);
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public List<RVersion> getVersionHistory() throws RRepositoryException {
        try {
            VersionHistory vh = this.node().getVersionHistory();
            VersionIterator vi = vh.getAllVersions();
            LinkedList<RVersion> result = new LinkedList<RVersion>();
            while (vi.hasNext()) {
                Version v = vi.nextVersion();
                if (NodeUtil.isRootVersion(v)) continue;
                JcrVersion jvi = new JcrVersion(v);
                result.add(jvi);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get Version History.", (Throwable)e);
        }
    }

    protected Node node() {
        return this.node;
    }
}

