/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.repository.RCommonProject;
import org.openl.rules.repository.RLock;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonArtefact;
import org.openl.rules.repository.jcr.JcrLock;
import org.openl.rules.repository.jcr.JcrVersion;
import org.openl.rules.repository.jcr.NodeUtil;

public class JcrCommonProject
extends JcrCommonArtefact
implements RCommonProject {
    private static Log log = LogFactory.getLog(JcrCommonProject.class);
    private JcrVersion version;
    private JcrLock lock;
    private CommonVersionImpl risedVersion;

    protected JcrCommonProject(Node node) throws RepositoryException {
        super(node);
        this.version = new JcrVersion(node);
        this.lock = new JcrLock(node);
    }

    protected void checkInAll(Node n, CommonUser user) throws RepositoryException {
        boolean mustBeCheckedIn;
        NodeIterator ni = n.getNodes();
        while (ni.hasNext()) {
            Node child = ni.nextNode();
            this.checkInAll(child, user);
        }
        boolean saveProps = false;
        PropertyIterator pi = n.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            if (!p.isModified() && !p.isNew()) continue;
            saveProps = true;
            break;
        }
        boolean mustBeSaved = saveProps || n.isModified() || n.isNew();
        boolean bl = mustBeCheckedIn = n.isNodeType("mix:versionable") && n.isCheckedOut();
        if (mustBeCheckedIn) {
            this.version.updateRevision(n);
            n.setProperty("modifiedBy", user.getUserName());
            n.save();
            log.info((Object)("Checking in... " + n.getPath()));
            n.checkin();
        } else if (mustBeSaved) {
            log.info((Object)("Saving... " + n.getPath()));
            n.save();
        }
    }

    public void commit(CommonUser user) throws RRepositoryException {
        if (this.risedVersion != null) {
            this.version.set(this.risedVersion.getMajor(), this.risedVersion.getMinor());
            this.risedVersion = null;
        }
        try {
            Node n = this.node();
            NodeUtil.smartCheckout(n, true);
            this.version.nextRevision();
            this.version.updateVersion(n);
            this.checkInAll(n, user);
            this.commitParent(n.getParent());
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to checkin project ''{0}''!", (Throwable)e, new Object[]{this.getName()});
        }
    }

    protected void commitParent(Node parent) throws RepositoryException {
        if (parent.isModified()) {
            parent.save();
        }
        if (parent.isCheckedOut() && parent.isNodeType("mix:versionable")) {
            parent.checkin();
        }
    }

    public void delete(CommonUser user) throws RRepositoryException {
        if (this.isMarked4Deletion()) {
            throw new RRepositoryException("Project ''{0}'' is already marked for deletion!", null, new Object[]{this.getName()});
        }
        try {
            Node n = this.node();
            n.checkout();
            n.setProperty("marked4deletion", true);
            this.commit(user);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Mark project ''{0}'' for Deletion!", (Throwable)e, new Object[]{this.getName()});
        }
    }

    public void erase(CommonUser user) throws RRepositoryException {
        try {
            Node parent = this.node().getParent();
            log.info((Object)("Erasing project '" + this.getName() + "' on behalf of " + user.getUserName()));
            super.delete();
            this.commitParent(parent);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to delete project ''{0}''!", (Throwable)e, new Object[]{this.getName()});
        }
    }

    public RLock getLock() throws RRepositoryException {
        return this.lock;
    }

    public boolean isLocked() throws RRepositoryException {
        return this.lock.isLocked();
    }

    public boolean isMarked4Deletion() throws RRepositoryException {
        try {
            Node n = this.node();
            boolean isMarked = n.hasProperty("marked4deletion");
            return isMarked;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Check Marked4Deletion!", (Throwable)e);
        }
    }

    public void lock(CommonUser user) throws RRepositoryException {
        this.lock.lock(user);
    }

    public void riseVersion(int major, int minor) throws RRepositoryException {
        int ma = this.version.getMajor();
        int mi = this.version.getMinor();
        this.risedVersion = null;
        if (major < ma) {
            throw new RRepositoryException("New major version is less than current!", null);
        }
        if (major == ma && minor < mi) {
            throw new RRepositoryException("New minor version cannot be less than current, when major version remains unchanged!", null);
        }
        this.risedVersion = new CommonVersionImpl(major, minor, this.version.getRevision());
    }

    public void undelete(CommonUser user) throws RRepositoryException {
        if (!this.isMarked4Deletion()) {
            throw new RRepositoryException("Project ''{0}'' is not marked for deletion!", null, new Object[]{this.getName()});
        }
        try {
            Node n = this.node();
            n.checkout();
            n.setProperty("marked4deletion", (Value)null, 6);
            this.commit(user);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Unmark project ''{0}'' from Deletion!", (Throwable)e, new Object[]{this.getName()});
        }
    }

    public void unlock(CommonUser user) throws RRepositoryException {
        this.lock.unlock(user);
    }
}

