/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.RDependency;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonArtefact;
import org.openl.rules.repository.jcr.JcrDependency;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrDependencies
extends JcrCommonArtefact {
    protected JcrDependencies(Node node) throws RepositoryException {
        super(node);
    }

    @Override
    public RVersion getActiveVersion() {
        return null;
    }

    public Collection<RDependency> getDependencies() throws RRepositoryException {
        LinkedList<RDependency> result = new LinkedList<RDependency>();
        try {
            NodeIterator ni = this.node().getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                result.add(new JcrDependency(n));
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot get dependencies.", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<RVersion> getVersionHistory() throws RRepositoryException {
        throw new RRepositoryException("Not supported!", null);
    }

    public void updateDependencies(Collection<? extends RDependency> dependencies) throws RRepositoryException {
        try {
            NodeUtil.smartCheckout(this.node(), true);
            NodeIterator ni = this.node().getNodes();
            while (ni.hasNext()) {
                Node node = ni.nextNode();
                node.remove();
            }
            this.node().save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot reset dependencies.", (Throwable)e);
        }
        try {
            for (RDependency rDependency : dependencies) {
                JcrDependency.createDependency(this.node(), rDependency.getProjectName(), rDependency.getLowerLimit(), rDependency.getUpperLimit());
            }
            this.node().save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set dependencies.", (Throwable)e);
        }
    }
}

