/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.repository.RDependency;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonArtefact;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrDependency
extends JcrCommonArtefact
implements RDependency {
    private CommonVersion lowVersion = this.wrapProp("lowVersion");
    private CommonVersion highVersion = this.wrapProp("highVersion");

    protected static JcrDependency createDependency(Node parentNode, String nodeName, CommonVersion lowVersion, CommonVersion highVersion) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:dependency", false);
        if (lowVersion != null) {
            n.setProperty("lowVersion", lowVersion.getVersionName());
        }
        if (highVersion != null) {
            n.setProperty("highVersion", highVersion.getVersionName());
        }
        parentNode.save();
        n.save();
        return new JcrDependency(n);
    }

    protected JcrDependency(Node node) throws RepositoryException {
        super(node);
    }

    @Override
    public RVersion getActiveVersion() {
        return null;
    }

    public CommonVersion getLowerLimit() {
        return this.lowVersion;
    }

    public String getProjectName() {
        return this.getName();
    }

    public CommonVersion getUpperLimit() {
        return this.highVersion;
    }

    @Override
    public List<RVersion> getVersionHistory() throws RRepositoryException {
        throw new RRepositoryException("Not supported!", null);
    }

    public boolean hasUpperLimit() {
        return this.highVersion != null;
    }

    protected CommonVersion wrapProp(String propName) throws RepositoryException {
        if (!this.node().hasProperty(propName)) {
            return null;
        }
        String s = this.node().getProperty(propName).getString();
        return new CommonVersionImpl(s);
    }
}

