/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RProjectDescriptor;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonProject;
import org.openl.rules.repository.jcr.JcrOldDeploymentProject;
import org.openl.rules.repository.jcr.JcrProjectDescriptor;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrDeploymentDescriptorProject
extends JcrCommonProject
implements RDeploymentDescriptorProject {
    private HashMap<String, RProjectDescriptor> projects = new HashMap();

    protected static JcrDeploymentDescriptorProject createProject(Node parentNode, String name) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, name, "openl:deploymentProject", true);
        parentNode.save();
        n.checkin();
        n.save();
        return new JcrDeploymentDescriptorProject(n);
    }

    public JcrDeploymentDescriptorProject(Node node) throws RepositoryException {
        super(node);
        NodeIterator ni = node.getNodes();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            JcrProjectDescriptor pd = new JcrProjectDescriptor(n);
            this.projects.put(pd.getProjectName(), pd);
        }
    }

    public RProjectDescriptor createProjectDescriptor(String name) throws RRepositoryException {
        Node node = this.node();
        try {
            return JcrProjectDescriptor.create(node, name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot create project descriptor ''{0}''.", (Throwable)e, new Object[]{name});
        }
    }

    public Collection<RProjectDescriptor> getProjectDescriptors() {
        return this.projects.values();
    }

    public RDeploymentDescriptorProject getProjectVersion(CommonVersion version) throws RRepositoryException {
        try {
            Node frozenNode = NodeUtil.getNode4Version(this.node(), version);
            return new JcrOldDeploymentProject(this.getName(), frozenNode);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot get project version.", (Throwable)e);
        }
    }

    public void setProjectDescriptors(Collection<RProjectDescriptor> projectDescriptors) throws RRepositoryException {
        try {
            Node node = this.node();
            NodeUtil.smartCheckout(node, false);
            NodeIterator ni = node.getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                n.remove();
            }
            HashMap<String, JcrProjectDescriptor> newProjects = new HashMap<String, JcrProjectDescriptor>();
            for (RProjectDescriptor pd : projectDescriptors) {
                JcrProjectDescriptor newPD = JcrProjectDescriptor.create(node, pd.getProjectName());
                newPD.setProjectVersion(pd.getProjectVersion());
                newProjects.put(newPD.getProjectName(), newPD);
            }
            this.projects.clear();
            this.projects = newProjects;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set project descriptors for ''{0}''.", (Throwable)e, new Object[]{this.getName()});
        }
    }
}

