/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RProperty;
import org.openl.rules.repository.RPropertyType;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonArtefact;
import org.openl.rules.repository.jcr.JcrProperty;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrEntity
extends JcrCommonArtefact
implements REntity {
    private static final String[] ALLOWED_PROPS = new String[0];
    private Map<String, RProperty> properties;
    private Date effectiveDate;
    private Date expirationDate;
    private String lineOfBusiness;
    private Map<String, Object> props;

    public JcrEntity(Node node) throws RepositoryException {
        super(node);
        if (node.hasProperty("effectiveDate")) {
            this.effectiveDate = node.getProperty("effectiveDate").getDate().getTime();
        }
        if (node.hasProperty("expirationDate")) {
            this.expirationDate = node.getProperty("expirationDate").getDate().getTime();
        }
        if (node.hasProperty("LOB")) {
            this.lineOfBusiness = node.getProperty("LOB").getString();
        }
        this.properties = new HashMap<String, RProperty>();
        this.initProperties();
        this.props = new HashMap<String, Object>();
        this.loadProps();
    }

    public void addProperty(String name, RPropertyType type, Object value) throws RRepositoryException {
        try {
            NodeUtil.smartCheckout(this.node(), false);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Internal error.", (Throwable)e);
        }
        if (this.hasProperty(name)) {
            this.removeProperty(name);
        }
        JcrProperty jp = new JcrProperty(this, name, type, value);
        this.properties.put(name, jp);
    }

    private void buildRelPath(StringBuilder sb, Node n) throws RepositoryException {
        if (!n.isNodeType("openl:project")) {
            this.buildRelPath(sb, n.getParent());
        }
        if (!n.isNodeType("openl:files")) {
            sb.append('/');
            sb.append(n.getName());
        }
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getLineOfBusiness() {
        return this.lineOfBusiness;
    }

    public String getPath() throws RRepositoryException {
        StringBuilder sb = new StringBuilder(128);
        try {
            this.buildRelPath(sb, this.node());
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get relative path.", (Throwable)e);
        }
        return sb.toString();
    }

    public Collection<RProperty> getProperties() {
        return this.properties.values();
    }

    public RProperty getProperty(String name) throws RRepositoryException {
        RProperty rp = this.properties.get(name);
        if (rp == null) {
            throw new RRepositoryException("No such property ''{0}''.", null, new Object[]{name});
        }
        return rp;
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public boolean hasProperty(String name) {
        return this.properties.get(name) != null;
    }

    private void initProperties() throws RepositoryException {
        this.properties.clear();
        Node n = this.node();
        for (String s : ALLOWED_PROPS) {
            if (!n.hasProperty(s)) continue;
            Property p = n.getProperty(s);
            JcrProperty prop = new JcrProperty(this, p);
            this.properties.put(prop.getName(), prop);
        }
    }

    private void loadProps() throws RepositoryException {
        Node n = this.node();
        for (int i = 1; i <= 15; ++i) {
            String propName = "attribute" + i;
            if (!n.hasProperty(propName)) continue;
            Value value = n.getProperty(propName).getValue();
            Object propValue = null;
            int valueType = value.getType();
            switch (valueType) {
                case 5: {
                    propValue = value.getDate().getTime();
                    break;
                }
                case 4: {
                    propValue = value.getDouble();
                    break;
                }
                default: {
                    propValue = value.getString();
                }
            }
            this.props.put(propName, propValue);
        }
    }

    public void removeProperty(String name) throws RRepositoryException {
        RProperty rp = this.properties.get(name);
        if (rp == null) {
            throw new RRepositoryException("No such property ''{0}''.", null, new Object[]{name});
        }
        Node n = this.node();
        try {
            NodeUtil.smartCheckout(n, false);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Internal error.", (Throwable)e);
        }
        try {
            n.getProperty(name).remove();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot remove property ''{0}''.", (Throwable)e, new Object[]{name});
        }
        this.properties.remove(name);
    }

    public void setEffectiveDate(Date date) throws RRepositoryException {
        if (NodeUtil.isSame(this.effectiveDate, date)) {
            return;
        }
        Node n = this.node();
        Calendar c = NodeUtil.convertDate2Calendar(date);
        try {
            NodeUtil.smartCheckout(n, false);
            n.setProperty("effectiveDate", c);
            this.effectiveDate = date;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set effectiveDate.", (Throwable)e);
        }
    }

    public void setExpirationDate(Date date) throws RRepositoryException {
        if (NodeUtil.isSame(this.expirationDate, date)) {
            return;
        }
        Node n = this.node();
        Calendar c = NodeUtil.convertDate2Calendar(date);
        try {
            NodeUtil.smartCheckout(n, false);
            n.setProperty("expirationDate", c);
            this.expirationDate = date;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set expirationDate.", (Throwable)e);
        }
    }

    public void setLineOfBusiness(String lineOfBusiness) throws RRepositoryException {
        if (NodeUtil.isSame(this.lineOfBusiness, lineOfBusiness)) {
            return;
        }
        Node n = this.node();
        try {
            NodeUtil.smartCheckout(n, false);
            n.setProperty("LOB", lineOfBusiness);
            this.lineOfBusiness = lineOfBusiness;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set LOB.", (Throwable)e);
        }
    }

    private void setProperty(String propName, Object propValue) throws RRepositoryException {
        Node n = this.node();
        try {
            NodeUtil.smartCheckout(n, false);
            if (propValue instanceof Date) {
                n.setProperty(propName, ((Date)propValue).getTime());
            } else if (propValue instanceof Double) {
                n.setProperty(propName, ((Double)propValue).doubleValue());
            } else {
                n.setProperty(propName, (String)propValue);
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set property " + propName + ".", (Throwable)e);
        }
    }

    public void setProps(Map<String, Object> props) throws RRepositoryException {
        if (props == null) {
            return;
        }
        if (NodeUtil.isSame(this.props, props)) {
            return;
        }
        Set<String> propNames = props.keySet();
        for (String propName : propNames) {
            Object propValue = props.get(propName);
            this.setProperty(propName, propValue);
        }
        this.props = props;
    }
}

