/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrEntity;
import org.openl.rules.repository.jcr.NodeUtil;

public class JcrFile
extends JcrEntity
implements RFile {
    protected static JcrFile createFile(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createFileNode(parentNode, nodeName);
        parentNode.save();
        n.save();
        return new JcrFile(n);
    }

    public JcrFile(Node node) throws RepositoryException {
        super(node);
        NodeUtil.checkNodeType(node, "openl:file");
    }

    public InputStream getContent() throws RRepositoryException {
        return NodeUtil.getFileNodeContent(this.node());
    }

    public InputStream getContent4Version(CommonVersion version) throws RRepositoryException {
        try {
            Node frozen = NodeUtil.getNode4Version(this.node(), version);
            Node resNode = frozen.getNode("jcr:content");
            InputStream result = resNode.getProperty("jcr:data").getStream();
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get Content for specified version.", (Throwable)e);
        }
    }

    public String getMimeType() {
        return null;
    }

    public long getSize() {
        return NodeUtil.getFileNodeSize(this.node());
    }

    public void revertToVersion(String versionName) throws RRepositoryException {
        try {
            Node n = this.node();
            n.restore(versionName, true);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to revert to specified version.", (Throwable)e);
        }
    }

    public void setContent(InputStream inputStream) throws RRepositoryException {
        try {
            Node n = this.node();
            NodeUtil.smartCheckout(n, false);
            Node resNode = n.getNode("jcr:content");
            long lastModifiedTime = System.currentTimeMillis();
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(lastModifiedTime);
            resNode.setProperty("jcr:data", inputStream);
            resNode.setProperty("jcr:lastModified", lastModified);
            n.save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to set Content.", (Throwable)e);
        }
    }
}

