/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrEntity;
import org.openl.rules.repository.jcr.JcrFile;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrFolder
extends JcrEntity
implements RFolder {
    protected static JcrFolder createFolder(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:folder", true);
        parentNode.save();
        n.save();
        return new JcrFolder(n);
    }

    public JcrFolder(Node node) throws RepositoryException {
        super(node);
        NodeUtil.checkNodeType(node, "openl:folder");
    }

    public RFile createFile(String name) throws RRepositoryException {
        try {
            return JcrFile.createFile(this.node(), name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Create File.", (Throwable)e);
        }
    }

    public RFolder createFolder(String name) throws RRepositoryException {
        try {
            return JcrFolder.createFolder(this.node(), name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to Create Sub Folder.", (Throwable)e);
        }
    }

    public List<RFile> getFiles() throws RRepositoryException {
        LinkedList<RFile> result = new LinkedList<RFile>();
        this.listNodes(result, true);
        return result;
    }

    public List<RFolder> getFolders() throws RRepositoryException {
        LinkedList<RFolder> result = new LinkedList<RFolder>();
        this.listNodes(result, false);
        return result;
    }

    private void listNodes(List list2add, boolean isFiles) throws RRepositoryException {
        try {
            NodeIterator ni = this.node().getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                if (n.isNodeType("openl:folder")) {
                    if (isFiles) continue;
                    list2add.add(new JcrFolder(n));
                    continue;
                }
                if (!isFiles) continue;
                list2add.add(new JcrFile(n));
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to list nodes.", (Throwable)e);
        }
    }
}

