/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonUserImpl;
import org.openl.rules.repository.RLock;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.NodeUtil;

public class JcrLock
implements RLock {
    private static final Log log = LogFactory.getLog(JcrLock.class);
    private Node node;

    protected JcrLock(Node projectNode) throws RepositoryException {
        String projectName = projectNode.getName();
        Node parent = projectNode.getParent();
        String lockNode = "lock~" + projectName;
        if (parent.hasNode(lockNode)) {
            this.node = parent.getNode(lockNode);
        } else {
            this.node = NodeUtil.createNode(parent, lockNode, "openl:lock", false);
            parent.save();
        }
    }

    protected Calendar currTime() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return c;
    }

    public Date getLockedAt() {
        try {
            if (this.node.hasProperty("lockedAt")) {
                return this.node.getProperty("lockedAt").getDate().getTime();
            }
        }
        catch (RepositoryException e) {
            log.info((Object)"getLockedAt", (Throwable)e);
        }
        return null;
    }

    public CommonUser getLockedBy() {
        try {
            if (this.node.hasProperty("lockedBy")) {
                String whoLocked = this.node.getProperty("lockedBy").getString();
                return new CommonUserImpl(whoLocked);
            }
        }
        catch (RepositoryException e) {
            log.info((Object)"getLockedBy", (Throwable)e);
        }
        return null;
    }

    public boolean isLocked() {
        try {
            return this.node.hasProperty("lockedBy");
        }
        catch (RepositoryException e) {
            log.info((Object)"isLocked", (Throwable)e);
            return false;
        }
    }

    protected void lock(CommonUser user) throws RRepositoryException {
        try {
            if (this.node.hasProperty("lockedBy")) {
                String whoLocked = this.node.getProperty("lockedBy").getString();
                throw new RRepositoryException("Already locked by ''{0}''.", null, new Object[]{whoLocked});
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot check lock.", (Throwable)e);
        }
        try {
            this.node.setProperty("lockedBy", user.getUserName());
            this.node.setProperty("lockedAt", this.currTime());
            this.node.save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to set lock.", (Throwable)e);
        }
    }

    protected void unlock(CommonUser user) throws RRepositoryException {
        try {
            String whoUnlocks;
            if (!this.node.hasProperty("lockedBy")) {
                return;
            }
            String whoLocked = this.node.getProperty("lockedBy").getString();
            if (!whoLocked.equals(whoUnlocks = user.getUserName())) {
                throw new RRepositoryException("Lock that was set by ''{0}'' cannot be removed by ''{1}''.", null, new Object[]{whoLocked, whoUnlocks});
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot check lock.", (Throwable)e);
        }
        try {
            this.node.setProperty("lockedBy", (String)null);
            this.node.setProperty("lockedAt", (Calendar)null);
            this.node.save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to remove lock.", (Throwable)e);
        }
    }
}

