/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RProperty;
import org.openl.rules.repository.RPropertyType;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrOldEntity
implements REntity {
    private Node node;
    private String name;
    private JcrVersion version;
    private JcrOldEntity parent;
    private Date effectiveDate;
    private Date expirationDate;
    private String lineOfBusiness;
    private Map<String, Object> props;

    public JcrOldEntity(JcrOldEntity parent, String name, Node node) throws RepositoryException {
        this.parent = parent;
        this.node = node;
        this.name = name;
        this.version = new JcrVersion(node);
        if (node.hasProperty("effectiveDate")) {
            this.effectiveDate = node.getProperty("effectiveDate").getDate().getTime();
        }
        if (node.hasProperty("expirationDate")) {
            this.expirationDate = node.getProperty("expirationDate").getDate().getTime();
        }
        if (node.hasProperty("LOB")) {
            this.lineOfBusiness = node.getProperty("LOB").getString();
        }
        this.props = new HashMap<String, Object>();
        this.loadProps();
    }

    public void addProperty(String name, RPropertyType type, Object value) throws RRepositoryException {
        this.notSupported();
    }

    protected void checkNodeType(String frozenNodeType) throws RepositoryException {
        if (!this.node.isNodeType("nt:frozenNode")) {
            throw new RepositoryException("Not a frozen node!");
        }
        String actualFrozenNodeType = this.node.getProperty("jcr:frozenPrimaryType").getString();
        if ("openl:files".equals(actualFrozenNodeType) && "openl:folder".equals(frozenNodeType)) {
            return;
        }
        if (!frozenNodeType.equals(actualFrozenNodeType)) {
            throw new RepositoryException("Invalid NodeType '" + actualFrozenNodeType + "'. Expects '" + frozenNodeType + "'.");
        }
    }

    public void delete() throws RRepositoryException {
        this.notSupported();
    }

    public RVersion getActiveVersion() {
        return this.version;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getLineOfBusiness() {
        return this.lineOfBusiness;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() throws RRepositoryException {
        JcrOldEntity curr = this;
        StringBuilder sb = new StringBuilder(128);
        while (curr != null) {
            String s = curr.getName();
            if (s != null) {
                sb.insert(0, s);
                sb.insert(0, '/');
            }
            curr = curr.parent;
        }
        return sb.toString();
    }

    public Collection<RProperty> getProperties() {
        return null;
    }

    public RProperty getProperty(String name) throws RRepositoryException {
        throw new RRepositoryException("Cannot find property", null);
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public List<RVersion> getVersionHistory() throws RRepositoryException {
        LinkedList<RVersion> result = new LinkedList<RVersion>();
        result.add(this.version);
        return result;
    }

    public boolean hasProperty(String name) {
        return false;
    }

    private void loadProps() throws RepositoryException {
        Node n = this.node();
        for (int i = 1; i <= 15; ++i) {
            String propName = "attribute" + i;
            if (!n.hasProperty(propName)) continue;
            Value value = n.getProperty(propName).getValue();
            Object propValue = null;
            int valueType = value.getType();
            switch (valueType) {
                case 5: {
                    propValue = value.getDate().getTime();
                    break;
                }
                case 4: {
                    propValue = value.getDouble();
                    break;
                }
                default: {
                    propValue = value.getString();
                }
            }
            this.props.put(propName, propValue);
        }
    }

    protected Node node() {
        return this.node;
    }

    protected void notSupported() throws RRepositoryException {
        throw new RRepositoryException("Cannot modify artefact version!", null);
    }

    public void removeProperty(String name) throws RRepositoryException {
        this.notSupported();
    }

    public void setEffectiveDate(Date date) throws RRepositoryException {
        this.notSupported();
    }

    public void setExpirationDate(Date date) throws RRepositoryException {
        this.notSupported();
    }

    public void setLineOfBusiness(String lineOfBusiness) throws RRepositoryException {
        this.notSupported();
    }

    public void setProps(Map<String, Object> props) throws RRepositoryException {
        this.notSupported();
    }
}

