/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.io.InputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrOldEntity;

public class JcrOldFile
extends JcrOldEntity
implements RFile {
    private static final Log log = LogFactory.getLog(JcrOldFile.class);

    public JcrOldFile(JcrOldEntity parent, String name, Node node) throws RepositoryException {
        super(parent, name, node);
        this.checkNodeType("openl:file");
    }

    public InputStream getContent() throws RRepositoryException {
        try {
            Node n = this.node();
            Node resNode = n.getNode("jcr:content");
            InputStream result = resNode.getProperty("jcr:data").getStream();
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get Content.", (Throwable)e);
        }
    }

    public InputStream getContent4Version(CommonVersion version) throws RRepositoryException {
        throw new RRepositoryException("In versioned mode can work with one version only!", null);
    }

    public String getMimeType() {
        return null;
    }

    public long getSize() {
        long result;
        try {
            Node n = this.node();
            Node resNode = n.getNode("jcr:content");
            result = resNode.getProperty("jcr:data").getLength();
        }
        catch (RepositoryException e) {
            log.info((Object)"getSize", (Throwable)e);
            result = -1L;
        }
        return result;
    }

    public void revertToVersion(String versionName) throws RRepositoryException {
        this.notSupported();
    }

    public void setContent(InputStream inputStream) throws RRepositoryException {
        this.notSupported();
    }
}

