/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrOldEntity;
import org.openl.rules.repository.jcr.JcrOldFile;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrOldFolder
extends JcrOldEntity
implements RFolder {
    private CommonVersion projectVersion;

    public JcrOldFolder(JcrOldEntity parent, String name, Node node, CommonVersion projectVersion) throws RepositoryException {
        super(parent, name, node);
        this.checkNodeType("openl:folder");
        this.projectVersion = projectVersion;
    }

    public RFile createFile(String name) throws RRepositoryException {
        this.notSupported();
        return null;
    }

    public RFolder createFolder(String name) throws RRepositoryException {
        this.notSupported();
        return null;
    }

    public List<RFile> getFiles() throws RRepositoryException {
        LinkedList<RFile> result = new LinkedList<RFile>();
        this.listNodes(result, true);
        return result;
    }

    public List<RFolder> getFolders() throws RRepositoryException {
        LinkedList<RFolder> result = new LinkedList<RFolder>();
        this.listNodes(result, false);
        return result;
    }

    protected void listNodes(List list2add, boolean isFiles) throws RRepositoryException {
        try {
            NodeIterator ni = this.node().getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                String name = n.getName();
                Node frozenNode = NodeUtil.normalizeOldNode(n, this.projectVersion);
                String frozenNodeType = frozenNode.getProperty("jcr:frozenPrimaryType").getString();
                if ("openl:folder".equals(frozenNodeType)) {
                    if (isFiles) continue;
                    list2add.add(new JcrOldFolder(this, name, frozenNode, this.projectVersion));
                    continue;
                }
                if (!isFiles) continue;
                list2add.add(new JcrOldFile(this, name, frozenNode));
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to list nodes.", (Throwable)e);
        }
    }
}

