/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RDependency;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.RLock;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrDependencies;
import org.openl.rules.repository.jcr.JcrOldEntity;
import org.openl.rules.repository.jcr.JcrOldFolder;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrOldProject
extends JcrOldEntity
implements RProject {
    public static final RLock NO_LOCK = new RLock(){

        public Date getLockedAt() {
            return null;
        }

        public CommonUser getLockedBy() {
            return null;
        }

        public boolean isLocked() {
            return false;
        }
    };
    private JcrOldFolder rootFolder;
    private JcrDependencies dependencies;

    public JcrOldProject(String name, Node node, CommonVersion version) throws RepositoryException {
        super(null, name, node);
        this.checkNodeType("openl:project");
        Node files = NodeUtil.normalizeOldNode(node.getNode("files"), version);
        this.rootFolder = new JcrOldFolder(this, null, files, version);
        Node deps = node.getNode("dependencies");
        this.dependencies = new JcrDependencies(deps);
    }

    public void commit(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }

    public void delete(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }

    public void erase(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }

    public Collection<RDependency> getDependencies() throws RRepositoryException {
        return this.dependencies.getDependencies();
    }

    public RLock getLock() throws RRepositoryException {
        return NO_LOCK;
    }

    public RProject getProjectVersion(CommonVersion version) throws RRepositoryException {
        throw new RRepositoryException("In versioned mode can work with one version only!", null);
    }

    public RFolder getRootFolder() {
        return this.rootFolder;
    }

    public boolean isLocked() throws RRepositoryException {
        return false;
    }

    public boolean isMarked4Deletion() throws RRepositoryException {
        return false;
    }

    public void lock(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }

    public void riseVersion(int major, int minor) throws RRepositoryException {
        this.notSupported();
    }

    public void setDependencies(Collection<? extends RDependency> dependencies) throws RRepositoryException {
        this.notSupported();
    }

    public void undelete(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }

    public void unlock(CommonUser user) throws RRepositoryException {
        this.notSupported();
    }
}

