/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.ArrayList;
import java.util.Collection;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.RProductionDeployment;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrProductionEntity;
import org.openl.rules.repository.jcr.JcrProductionProject;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProductionDeployment
extends JcrProductionEntity
implements RProductionDeployment {
    private static final Object lock = new Object();
    private Node node;

    static JcrProductionDeployment createDeployment(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:deployment", false);
        parentNode.save();
        n.save();
        return new JcrProductionDeployment(n);
    }

    public JcrProductionDeployment(Node node) throws RepositoryException {
        super(node);
        NodeUtil.checkNodeType(node, "openl:deployment");
        this.node = node;
    }

    public RProject createProject(String projectName) throws RRepositoryException {
        try {
            return JcrProductionProject.createProject(this.node, projectName);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to create project!", (Throwable)e);
        }
    }

    public RProject getProject(String name) throws RRepositoryException {
        try {
            return new JcrProductionProject(this.node.getNode(name));
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get project " + name, (Throwable)e);
        }
    }

    public Collection<RProject> getProjects() throws RRepositoryException {
        ArrayList<RProject> result = new ArrayList<RProject>();
        try {
            NodeIterator nodeIterator = this.node().getNodes();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                if (!node.getPrimaryNodeType().getName().equals("openl:dproject")) continue;
                result.add(this.getProject(node.getName()));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get projects!", (Throwable)e);
        }
    }

    public boolean hasProject(String name) throws RRepositoryException {
        try {
            return this.node.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to check if project exists!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repositoryNotify() throws RepositoryException {
        Object object = lock;
        synchronized (object) {
            Node root = this.node.getParent();
            root.setProperty("deploymentReady", (String)null);
            root.setProperty("deploymentReady", "1");
            this.node.getParent().save();
        }
    }

    public void save() throws RRepositoryException {
        try {
            this.node.save();
            this.repositoryNotify();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to save deployment!", (Throwable)e);
        }
    }
}

