/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RProperty;
import org.openl.rules.repository.RPropertyType;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JcrProductionEntity
implements REntity {
    private String name;
    private Node node;
    private Date effectiveDate;
    private Date expirationDate;
    private String lineOfBusiness;
    private Map<String, Object> props;

    public JcrProductionEntity(Node node) throws RepositoryException {
        this.node = node;
        this.name = node.getName();
        if (node.hasProperty("effectiveDate")) {
            this.effectiveDate = new Date(node.getProperty("effectiveDate").getLong());
        }
        if (node.hasProperty("expirationDate")) {
            this.expirationDate = new Date(node.getProperty("expirationDate").getLong());
        }
        if (node.hasProperty("LOB")) {
            this.lineOfBusiness = node.getProperty("LOB").getString();
        }
        this.props = new HashMap<String, Object>();
        this.loadProps();
    }

    public void addProperty(String name, RPropertyType type, Object value) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    private void buildPath(Node node, StringBuilder sb) throws RepositoryException {
        if (!node.isNodeType("openl:deployment")) {
            this.buildPath(node.getParent(), sb);
        }
        sb.append("/").append(node.getName());
    }

    public void delete() throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public RVersion getActiveVersion() {
        return null;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getLineOfBusiness() {
        return this.lineOfBusiness;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() throws RRepositoryException {
        StringBuilder sb = new StringBuilder(32);
        try {
            this.buildPath(this.node(), sb);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("error building path", (Throwable)e);
        }
        return sb.toString();
    }

    public Collection<RProperty> getProperties() {
        return null;
    }

    public RProperty getProperty(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public List<RVersion> getVersionHistory() throws RRepositoryException {
        return null;
    }

    public boolean hasProperty(String name) {
        throw new UnsupportedOperationException();
    }

    private void loadProps() throws RepositoryException {
        Node n = this.node();
        for (int i = 1; i <= 15; ++i) {
            String propName = "attribute" + i;
            if (!n.hasProperty(propName)) continue;
            Value value = n.getProperty(propName).getValue();
            Object propValue = null;
            int valueType = value.getType();
            switch (valueType) {
                case 5: {
                    propValue = value.getDate().getTime();
                    break;
                }
                case 4: {
                    propValue = value.getDouble();
                    break;
                }
                default: {
                    propValue = value.getString();
                }
            }
            this.props.put(propName, propValue);
        }
    }

    protected Node node() {
        return this.node;
    }

    public void removeProperty(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setEffectiveDate(Date date) throws RRepositoryException {
        if (NodeUtil.isSame(this.effectiveDate, date)) {
            return;
        }
        Node n = this.node();
        try {
            n.setProperty("effectiveDate", date.getTime());
            this.effectiveDate = date;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set effectiveDate", (Throwable)e);
        }
    }

    public void setExpirationDate(Date date) throws RRepositoryException {
        if (NodeUtil.isSame(this.expirationDate, date)) {
            return;
        }
        Node n = this.node();
        try {
            n.setProperty("expirationDate", date.getTime());
            this.expirationDate = date;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set expirationDate", (Throwable)e);
        }
    }

    public void setLineOfBusiness(String lineOfBusiness) throws RRepositoryException {
        if (NodeUtil.isSame(this.lineOfBusiness, lineOfBusiness)) {
            return;
        }
        Node n = this.node();
        try {
            n.setProperty("LOB", lineOfBusiness);
            this.lineOfBusiness = lineOfBusiness;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set LOB", (Throwable)e);
        }
    }

    private boolean setProperty(String propName, Object propValue) throws RRepositoryException {
        Node n = this.node();
        try {
            NodeUtil.smartCheckout(n, false);
            if (propValue instanceof Date) {
                n.setProperty(propName, ((Date)propValue).getTime());
            } else if (propValue instanceof Double) {
                n.setProperty(propName, ((Double)propValue).doubleValue());
            } else {
                n.setProperty(propName, propValue.toString());
            }
            return true;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set property " + propName + ".", (Throwable)e);
        }
    }

    public void setProps(Map<String, Object> props) throws RRepositoryException {
        if (props == null) {
            return;
        }
        if (NodeUtil.isSame(this.props, props)) {
            return;
        }
        Set<String> propNames = props.keySet();
        for (String propName : propNames) {
            Object propValue = props.get(propName);
            this.setProperty(propName, propValue);
        }
        this.props = props;
    }
}

