/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrProductionEntity;
import org.openl.rules.repository.jcr.NodeUtil;

public class JcrProductionFile
extends JcrProductionEntity
implements RFile {
    protected static JcrProductionFile createFile(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createProdFileNode(parentNode, nodeName);
        parentNode.save();
        n.save();
        return new JcrProductionFile(n);
    }

    public JcrProductionFile(Node n) throws RepositoryException {
        super(n);
    }

    public InputStream getContent() throws RRepositoryException {
        return NodeUtil.getFileNodeContent(this.node());
    }

    public InputStream getContent4Version(CommonVersion version) throws RRepositoryException {
        return this.getContent();
    }

    public String getMimeType() {
        return null;
    }

    public long getSize() {
        return NodeUtil.getFileNodeSize(this.node());
    }

    public void revertToVersion(String versionName) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public void setContent(InputStream inputStream) throws RRepositoryException {
        try {
            Node n = this.node();
            Node resNode = n.getNode("jcr:content");
            long lastModifiedTime = System.currentTimeMillis();
            Calendar lastModified = Calendar.getInstance();
            lastModified.setTimeInMillis(lastModifiedTime);
            resNode.setProperty("jcr:data", inputStream);
            resNode.setProperty("jcr:lastModified", lastModified);
            n.save();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to set Content", (Throwable)e);
        }
    }
}

