/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.RFile;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrProductionEntity;
import org.openl.rules.repository.jcr.JcrProductionFile;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProductionFolder
extends JcrProductionEntity
implements RFolder {
    protected static JcrProductionFolder createFolder(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:dfolder", false);
        parentNode.save();
        n.save();
        return new JcrProductionFolder(n);
    }

    public JcrProductionFolder(Node node) throws RepositoryException {
        super(node);
    }

    public RFile createFile(String name) throws RRepositoryException {
        try {
            return JcrProductionFile.createFile(this.node(), name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to create file", (Throwable)e);
        }
    }

    public RFolder createFolder(String name) throws RRepositoryException {
        try {
            return JcrProductionFolder.createFolder(this.node(), name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to create subfolder", (Throwable)e);
        }
    }

    public List<RFile> getFiles() throws RRepositoryException {
        LinkedList<RFile> result = new LinkedList<RFile>();
        this.listNodes(result, true);
        return result;
    }

    public List<RFolder> getFolders() throws RRepositoryException {
        LinkedList<RFolder> result = new LinkedList<RFolder>();
        this.listNodes(result, false);
        return result;
    }

    private void listNodes(List list2add, boolean isFiles) throws RRepositoryException {
        try {
            NodeIterator ni = this.node().getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                if (n.isNodeType("openl:dfolder")) {
                    if (isFiles) continue;
                    list2add.add(new JcrProductionFolder(n));
                    continue;
                }
                if (!isFiles) continue;
                list2add.add(new JcrProductionFile(n));
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to list nodes", (Throwable)e);
        }
    }
}

