/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RDeploymentListener;
import org.openl.rules.repository.REntity;
import org.openl.rules.repository.RProductionDeployment;
import org.openl.rules.repository.RProductionRepository;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.BaseJcrRepository;
import org.openl.rules.repository.jcr.JcrProductionDeployment;
import org.openl.rules.repository.jcr.JcrProductionFile;
import org.openl.rules.repository.jcr.JcrProductionFolder;
import org.openl.rules.repository.jcr.JcrProductionProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProductionRepository
extends BaseJcrRepository
implements RProductionRepository,
EventListener {
    private static final Log log = LogFactory.getLog(JcrProductionRepository.class);
    static final String PROPERTY_NOTIFICATION = "deploymentReady";
    private static final String DEPLOY_ROOT = "/deploy";
    private Node deployLocation;
    private List<RDeploymentListener> listeners = new ArrayList<RDeploymentListener>();

    private static void appendDateCondition(Date date, String condition, StringBuilder sb) {
        if (date != null) {
            sb.append("[@").append(condition).append(date.getTime()).append("]");
        }
    }

    private static String buildQuery(RProductionRepository.SearchParams params) {
        StringBuilder sb = new StringBuilder("//element(*, nt:base)");
        if (!StringUtils.isEmpty((String)params.getLineOfBusiness())) {
            sb.append("[@LOB='").append(params.getLineOfBusiness()).append("']");
        }
        JcrProductionRepository.appendDateCondition(params.getLowerEffectiveDate(), "effectiveDate >= ", sb);
        JcrProductionRepository.appendDateCondition(params.getUpperEffectiveDate(), "effectiveDate <= ", sb);
        JcrProductionRepository.appendDateCondition(params.getLowerExpirationDate(), "expirationDate >= ", sb);
        JcrProductionRepository.appendDateCondition(params.getUpperExpirationDate(), "expirationDate <= ", sb);
        return sb.toString();
    }

    public JcrProductionRepository(String name, Session session) throws RepositoryException {
        super(name, session);
        this.deployLocation = this.checkPath(DEPLOY_ROOT);
        if (this.deployLocation.isNew()) {
            session.save();
        }
        session.getWorkspace().getObservationManager().addEventListener((EventListener)this, 4, DEPLOY_ROOT, false, null, null, false);
    }

    public synchronized void addListener(RDeploymentListener listener) throws RRepositoryException {
        this.listeners.add(listener);
    }

    public RDeploymentDescriptorProject createDDProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public RProductionDeployment createDeployment(String name) throws RRepositoryException {
        try {
            return JcrProductionDeployment.createDeployment(this.deployLocation, name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("could not create deployment {0}", (Throwable)e, new Object[]{name});
        }
    }

    public RProject createProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public Collection<REntity> findNodes(RProductionRepository.SearchParams params) throws RRepositoryException {
        try {
            Query query = this.session.getWorkspace().getQueryManager().createQuery(JcrProductionRepository.buildQuery(params), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            ArrayList<REntity> result = new ArrayList<REntity>();
            while (nodeIterator.hasNext()) {
                Node node = nodeIterator.nextNode();
                String type = node.getPrimaryNodeType().getName();
                if (type.equals("openl:deployment")) {
                    result.add(new JcrProductionDeployment(node));
                    continue;
                }
                if (type.equals("openl:dfolder")) {
                    result.add(new JcrProductionFolder(node));
                    continue;
                }
                if (type.equals("openl:dfile")) {
                    result.add(new JcrProductionFile(node));
                    continue;
                }
                if (!type.equals("openl:dproject")) continue;
                result.add(new JcrProductionProject(node));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to run query", (Throwable)e);
        }
    }

    public RDeploymentDescriptorProject getDDProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public List<RDeploymentDescriptorProject> getDDProjects() throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public RProductionDeployment getDeployment(String name) throws RRepositoryException {
        Node node;
        try {
            node = this.deployLocation.getNode(name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to get node", (Throwable)e);
        }
        try {
            return new JcrProductionDeployment(node);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to wrap JCR node", (Throwable)e);
        }
    }

    public Collection<String> getDeploymentNames() throws RRepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            NodeIterator iterator = this.deployLocation.getNodes();
            while (iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (!node.getPrimaryNodeType().getName().equals("openl:deployment")) continue;
                result.add(node.getName());
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to enumerate deployments", (Throwable)e);
        }
        return result;
    }

    public RProject getProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public List<RProject> getProjects() throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public List<RProject> getProjects4Deletion() throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasDDProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public boolean hasDeployment(String name) throws RRepositoryException {
        try {
            return this.deployLocation.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("failed to check project {0}", (Throwable)e, new Object[]{name});
        }
    }

    public boolean hasProject(String name) throws RRepositoryException {
        throw new UnsupportedOperationException();
    }

    public void onEvent(EventIterator eventIterator) {
        boolean hasInterestingEvents = false;
        while (eventIterator.hasNext()) {
            Event event = eventIterator.nextEvent();
            try {
                if (!event.getPath().equals("/deploy/deploymentReady")) continue;
                hasInterestingEvents = true;
                break;
            }
            catch (RepositoryException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"onEvent-1", (Throwable)e);
            }
        }
        if (hasInterestingEvents) {
            ArrayList<RDeploymentListener> listenersCopy = new ArrayList<RDeploymentListener>(this.listeners);
            for (RDeploymentListener l : listenersCopy) {
                try {
                    l.projectsAdded();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"onEvent-2", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void release() {
        block2: {
            try {
                this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"release", (Throwable)e);
            }
        }
        super.release();
    }

    public synchronized boolean removeListener(RDeploymentListener listener) throws RRepositoryException {
        return this.listeners.remove(listener);
    }
}

