/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Collection;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.RDependency;
import org.openl.rules.repository.RFolder;
import org.openl.rules.repository.RLock;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrCommonProject;
import org.openl.rules.repository.jcr.JcrDependencies;
import org.openl.rules.repository.jcr.JcrEntity;
import org.openl.rules.repository.jcr.JcrFolder;
import org.openl.rules.repository.jcr.JcrLock;
import org.openl.rules.repository.jcr.JcrOldProject;
import org.openl.rules.repository.jcr.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrProject
extends JcrEntity
implements RProject {
    public static final String NODE_FILES = "files";
    public static final String NODE_DEPENDENCIES = "dependencies";
    private JcrFolder rootFolder;
    private JcrDependencies dependencies;
    private JcrCommonProject project;
    private JcrLock lock;

    protected static JcrProject createProject(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:project", true);
        n.setProperty("description", "created " + new Date() + " by UNKNOWN");
        NodeUtil.createNode(n, NODE_FILES, "openl:files", true);
        NodeUtil.createNode(n, NODE_DEPENDENCIES, "openl:dependencies", false);
        parentNode.save();
        n.checkin();
        n.save();
        return new JcrProject(n);
    }

    public JcrProject(Node node) throws RepositoryException {
        super(node);
        NodeUtil.checkNodeType(node, "openl:project");
        Node files = node.getNode(NODE_FILES);
        this.rootFolder = new JcrFolder(files);
        Node deps = node.getNode(NODE_DEPENDENCIES);
        this.dependencies = new JcrDependencies(deps);
        this.project = new JcrCommonProject(node);
        this.lock = new JcrLock(node);
    }

    public void commit(CommonUser user) throws RRepositoryException {
        this.project.commit(user);
    }

    @Override
    public void delete() throws RRepositoryException {
        throw new RRepositoryException("Use delete(CommonUser) instead", null);
    }

    public void delete(CommonUser user) throws RRepositoryException {
        this.project.delete(user);
    }

    public void erase(CommonUser user) throws RRepositoryException {
        this.project.erase(user);
    }

    public Collection<RDependency> getDependencies() throws RRepositoryException {
        return this.dependencies.getDependencies();
    }

    public RLock getLock() throws RRepositoryException {
        return this.lock;
    }

    public RProject getProjectVersion(CommonVersion version) throws RRepositoryException {
        try {
            Node frozenNode = NodeUtil.getNode4Version(this.node(), version);
            return new JcrOldProject(this.getName(), frozenNode, version);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot get project version.", (Throwable)e);
        }
    }

    public RFolder getRootFolder() {
        return this.rootFolder;
    }

    public boolean isLocked() throws RRepositoryException {
        return this.lock.isLocked();
    }

    public boolean isMarked4Deletion() throws RRepositoryException {
        return this.project.isMarked4Deletion();
    }

    public void lock(CommonUser user) throws RRepositoryException {
        this.lock.lock(user);
    }

    public void riseVersion(int major, int minor) throws RRepositoryException {
        this.project.riseVersion(major, minor);
    }

    public void setDependencies(Collection<? extends RDependency> dependencies) throws RRepositoryException {
        this.dependencies.updateDependencies(dependencies);
    }

    public void undelete(CommonUser user) throws RRepositoryException {
        this.project.undelete(user);
    }

    public void unlock(CommonUser user) throws RRepositoryException {
        this.lock.unlock(user);
    }
}

