/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.openl.rules.repository.RProjectDescriptor;
import org.openl.rules.repository.RVersion;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrVersion;
import org.openl.rules.repository.jcr.NodeUtil;

public class JcrProjectDescriptor
implements RProjectDescriptor {
    private Node node;
    private String name;
    private JcrVersion version;

    protected static JcrProjectDescriptor create(Node parentNode, String projectName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, projectName, "openl:projectDescriptor", false);
        parentNode.save();
        return new JcrProjectDescriptor(n);
    }

    protected JcrProjectDescriptor(Node node) throws RepositoryException {
        this.node = node;
        this.name = node.getName();
        this.version = new JcrVersion(node);
    }

    public String getProjectName() {
        return this.name;
    }

    public RVersion getProjectVersion() {
        return this.version;
    }

    protected Node node() {
        return this.node;
    }

    public void setProjectVersion(RVersion version) throws RRepositoryException {
        Node n = this.node();
        this.version = new JcrVersion(version);
        try {
            this.version.updateVersion(n);
            this.version.updateRevision(n);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set project version.", (Throwable)e);
        }
    }
}

