/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.openl.rules.repository.RProperty;
import org.openl.rules.repository.RPropertyType;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrEntity;

public class JcrProperty
implements RProperty {
    private JcrEntity entity;
    private String name;
    private RPropertyType type;
    private Object value;

    protected JcrProperty(JcrEntity entity, Property p) throws RepositoryException {
        this.entity = entity;
        this.name = p.getName();
        Value v = p.getValue();
        switch (v.getType()) {
            case 5: {
                this.value = v.getDate().getTime();
                this.type = RPropertyType.DATE;
                break;
            }
            default: {
                this.value = v.getString();
                this.type = RPropertyType.STRING;
            }
        }
    }

    protected JcrProperty(JcrEntity entity, String name, RPropertyType type, Object value) throws RRepositoryException {
        this.entity = entity;
        this.name = name;
        this.type = type;
        this.value = value;
        try {
            Node n = entity.node();
            switch (type) {
                case DATE: {
                    Calendar c = this.date2Calendar((Date)value);
                    n.setProperty(name, c);
                    break;
                }
                default: {
                    n.setProperty(name, value.toString());
                    break;
                }
            }
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot create property ''{0}''.", (Throwable)e, new Object[]{name});
        }
    }

    private Calendar date2Calendar(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    public String getName() {
        return this.name;
    }

    public RPropertyType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) throws RRepositoryException {
        if (value == null) {
            this.entity.removeProperty(this.name);
            return;
        }
        try {
            Node n = this.entity.node();
            Property p = n.getProperty(this.name);
            switch (this.type) {
                case DATE: {
                    Calendar c = this.date2Calendar((Date)value);
                    p.setValue(c);
                    break;
                }
                default: {
                    p.setValue(value.toString());
                }
            }
            this.value = value;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Cannot set value for ''{0}''.", (Throwable)e, new Object[]{this.name});
        }
    }
}

