/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.openl.rules.repository.RDeploymentDescriptorProject;
import org.openl.rules.repository.RProject;
import org.openl.rules.repository.RRepository;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.BaseJcrRepository;
import org.openl.rules.repository.jcr.JcrDeploymentDescriptorProject;
import org.openl.rules.repository.jcr.JcrProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrRepository
extends BaseJcrRepository
implements RRepository {
    private static final String QUERY_PROJECTS = "//element(*, openl:project)";
    private static final String QUERY_PROJECTS_4_DEL = "//element(*, openl:project) [@marked4deletion]";
    private static final String QUERY_DDPROJECTS = "//element(*, openl:deploymentProject)";
    private Node defRulesLocation;
    private Node defDeploymentsLocation;

    public JcrRepository(String name, Session session, String defRulesPath, String defDeploymentsPath) throws RepositoryException {
        super(name, session);
        this.defRulesLocation = this.checkPath(defRulesPath);
        this.defDeploymentsLocation = this.checkPath(defDeploymentsPath);
        if (this.defRulesLocation.isNew() || this.defDeploymentsLocation.isNew()) {
            session.save();
        }
    }

    public RDeploymentDescriptorProject createDDProject(String nodeName) throws RRepositoryException {
        try {
            return JcrDeploymentDescriptorProject.createProject(this.defDeploymentsLocation, nodeName);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to create DDProject ''{0}''.", (Throwable)e, new Object[]{nodeName});
        }
    }

    public RProject createProject(String nodeName) throws RRepositoryException {
        try {
            return JcrProject.createProject(this.defRulesLocation, nodeName);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to create Project ''{0}''.", (Throwable)e, new Object[]{nodeName});
        }
    }

    public RDeploymentDescriptorProject getDDProject(String name) throws RRepositoryException {
        try {
            if (!this.defDeploymentsLocation.hasNode(name)) {
                throw new RRepositoryException("Cannot find Project ''{0}''.", null, new Object[]{name});
            }
            Node n = this.defDeploymentsLocation.getNode(name);
            JcrDeploymentDescriptorProject ddp = new JcrDeploymentDescriptorProject(n);
            return ddp;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get DDProject ''{0}''.", (Throwable)e, new Object[]{name});
        }
    }

    public List<RDeploymentDescriptorProject> getDDProjects() throws RRepositoryException {
        return this.runQueryDDP();
    }

    public RProject getProject(String name) throws RRepositoryException {
        try {
            if (!this.defRulesLocation.hasNode(name)) {
                throw new RRepositoryException("Cannot find project ''{0}''", null, new Object[]{name});
            }
            Node n = this.defRulesLocation.getNode(name);
            JcrProject p = new JcrProject(n);
            return p;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get project ''{0}''", (Throwable)e, new Object[]{name});
        }
    }

    public List<RProject> getProjects() throws RRepositoryException {
        return this.runQuery(QUERY_PROJECTS);
    }

    public List<RProject> getProjects4Deletion() throws RRepositoryException {
        return this.runQuery(QUERY_PROJECTS_4_DEL);
    }

    protected Session getSession() {
        return this.session;
    }

    public boolean hasDDProject(String name) throws RRepositoryException {
        try {
            return this.defDeploymentsLocation.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to check project ''{0}''", (Throwable)e, new Object[]{name});
        }
    }

    public boolean hasProject(String name) throws RRepositoryException {
        try {
            return this.defRulesLocation.hasNode(name);
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to check project ''{0}''", (Throwable)e, new Object[]{name});
        }
    }

    protected List<RProject> runQuery(String statement) throws RRepositoryException {
        try {
            QueryManager qm = this.session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(statement, "xpath");
            QueryResult qr = query.execute();
            LinkedList<RProject> result = new LinkedList<RProject>();
            NodeIterator ni = qr.getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                JcrProject p = new JcrProject(n);
                result.add(p);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to run query.", (Throwable)e);
        }
    }

    protected List<RDeploymentDescriptorProject> runQueryDDP() throws RRepositoryException {
        try {
            QueryManager qm = this.session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(QUERY_DDPROJECTS, "xpath");
            QueryResult qr = query.execute();
            LinkedList<RDeploymentDescriptorProject> result = new LinkedList<RDeploymentDescriptorProject>();
            NodeIterator ni = qr.getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                JcrDeploymentDescriptorProject ddp = new JcrDeploymentDescriptorProject(n);
                result.add(ddp);
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to run query.", (Throwable)e);
        }
    }
}

