/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.util.Date;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonUser;
import org.openl.rules.repository.CommonUserImpl;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.repository.RVersion;

public class JcrVersion
implements RVersion {
    private static final Log log = LogFactory.getLog(JcrVersion.class);
    private Date lastModified;
    private String modifiedBy;
    private CommonVersionImpl version;

    protected static void create(Node node) throws RepositoryException {
        node.setProperty("rVersion", 0L);
        node.setProperty("rRevision", 0L);
    }

    public JcrVersion(Node node) throws RepositoryException {
        this.initVersion(node);
        Node parent = node.getParent();
        if (parent.hasProperty("jcr:created")) {
            this.lastModified = parent.getProperty("jcr:created").getDate().getTime();
        }
    }

    public JcrVersion(RVersion version) {
        this.version = new CommonVersionImpl((CommonVersion)version);
    }

    public JcrVersion(Version version) throws RepositoryException {
        Node frozen = version.getNode("jcr:frozenNode");
        this.initVersion(frozen);
        this.lastModified = version.getProperty("jcr:created").getDate().getTime();
    }

    public int compareTo(CommonVersion o) {
        return this.version.compareTo(o);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JcrVersion)) {
            return false;
        }
        return this.compareTo((CommonVersion)((JcrVersion)obj)) == 0;
    }

    public Date getCreated() {
        return this.lastModified;
    }

    public CommonUser getCreatedBy() {
        if (this.modifiedBy == null) {
            return new CommonUserImpl("system");
        }
        return new CommonUserImpl(this.modifiedBy);
    }

    public int getMajor() {
        return this.version.getMajor();
    }

    public int getMinor() {
        return this.version.getMinor();
    }

    public int getRevision() {
        return this.version.getRevision();
    }

    public String getVersionName() {
        return this.version.getVersionName();
    }

    protected void initVersion(Node node) throws RepositoryException {
        int major = 0;
        int minor = 0;
        long revision = 0L;
        try {
            long l = node.getProperty("rVersion").getLong();
            int i = (int)l;
            major = i >> 16;
            minor = i & 0xFFFF;
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        try {
            revision = node.getProperty("rRevision").getLong();
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        this.version = new CommonVersionImpl(major, minor, (int)revision);
        if (node.hasProperty("modifiedBy")) {
            this.modifiedBy = node.getProperty("modifiedBy").getString();
        }
    }

    protected void nextRevision() {
        int newRevision = this.version.getRevision();
        this.version = new CommonVersionImpl(this.version.getMajor(), this.version.getMinor(), ++newRevision);
    }

    protected void set(int major, int minor) {
        this.version = new CommonVersionImpl(major, minor, this.version.getRevision());
    }

    protected void updateRevision(Node node) throws RepositoryException {
        node.setProperty("rRevision", (long)this.version.getRevision());
    }

    protected void updateVersion(Node node) throws RepositoryException {
        long l = (this.version.getMajor() & Short.MAX_VALUE) << 16 | this.version.getMinor() & Short.MAX_VALUE;
        node.setProperty("rVersion", l);
        node.setProperty("rRevision", (long)this.version.getRevision());
    }
}

