/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openl.rules.repository.CommonVersion;
import org.openl.rules.repository.CommonVersionImpl;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.jcr.JcrVersion;

public class NodeUtil {
    private static final Log log = LogFactory.getLog(NodeUtil.class);

    protected static void checkNodeType(Node node, String nodeType) throws RepositoryException {
        if (!node.isNodeType(nodeType)) {
            String actualNodeType = node.getPrimaryNodeType().getName();
            throw new RepositoryException("Invalid NodeType '" + actualNodeType + "'. Expects '" + nodeType + "'!");
        }
    }

    public static Calendar convertDate2Calendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    protected static Node createFileNode(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:file", true);
        NodeUtil.setupFileNode(n);
        return n;
    }

    protected static Node createNode(Node parentNode, String name, String type, boolean isVersionable) throws RepositoryException {
        if (parentNode.hasNode(name)) {
            throw new RepositoryException("Node '" + name + "' exists at '" + parentNode.getPath() + "' already!");
        }
        for (Node p = parentNode; p != null && !p.isCheckedOut(); p = p.getParent()) {
            if (!p.isNodeType("mix:versionable")) continue;
            p.checkout();
            break;
        }
        Node n = parentNode.addNode(name, type);
        if (isVersionable) {
            n.addMixin("mix:versionable");
        }
        return n;
    }

    protected static Node createProdFileNode(Node parentNode, String nodeName) throws RepositoryException {
        Node n = NodeUtil.createNode(parentNode, nodeName, "openl:dfile", false);
        NodeUtil.setupFileNode(n);
        return n;
    }

    protected static InputStream getFileNodeContent(Node node) throws RRepositoryException {
        try {
            return node.getNode("jcr:content").getProperty("jcr:data").getStream();
        }
        catch (RepositoryException e) {
            throw new RRepositoryException("Failed to get Content!", (Throwable)e);
        }
    }

    protected static long getFileNodeSize(Node node) {
        long result;
        try {
            Node resNode = node.getNode("jcr:content");
            result = resNode.getProperty("jcr:data").getLength();
        }
        catch (RepositoryException e) {
            log.warn((Object)"getFileNodeSize", (Throwable)e);
            result = -1L;
        }
        return result;
    }

    protected static Node getNode4Version(Node node, CommonVersion version) throws RepositoryException {
        Node result = null;
        VersionHistory vh = node.getVersionHistory();
        VersionIterator vi = vh.getAllVersions();
        while (vi.hasNext()) {
            JcrVersion jvi;
            CommonVersionImpl cv;
            Version jcrVersion = vi.nextVersion();
            if (NodeUtil.isRootVersion(jcrVersion) || (cv = new CommonVersionImpl((jvi = new JcrVersion(jcrVersion)).getMajor(), jvi.getMinor(), jvi.getRevision())).compareTo(version) != 0) continue;
            result = jcrVersion.getNode("jcr:frozenNode");
            break;
        }
        if (result == null) {
            throw new RepositoryException("Cannot find version '" + version.getVersionName() + "'!");
        }
        return result;
    }

    protected static boolean isRootVersion(Version v) throws RepositoryException {
        String name = v.getName();
        return "jcr:rootVersion".equals(name);
    }

    public static boolean isSame(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected static Node normalizeOldNode(Node node, CommonVersion version) throws RepositoryException {
        if (node.isNodeType("nt:frozenNode")) {
            return node;
        }
        if (!node.isNodeType("nt:versionedChild")) {
            return node;
        }
        Node versionHistoryNode = node.getProperty("jcr:childVersionHistory").getNode();
        int projectRevision = version.getRevision();
        int correctVRev = -1;
        Node correctVNode = null;
        NodeIterator versions = versionHistoryNode.getNodes();
        while (versions.hasNext()) {
            Node versionNode = versions.nextNode();
            if (!versionNode.isNodeType("nt:version")) continue;
            NodeIterator oldNodes = versionNode.getNodes();
            while (oldNodes.hasNext()) {
                Node oldNode = oldNodes.nextNode();
                int nodeRevision = 0;
                if (oldNode.hasProperty("rRevision")) {
                    nodeRevision = (int)oldNode.getProperty("rRevision").getLong();
                }
                if (nodeRevision > projectRevision || nodeRevision <= correctVRev) continue;
                correctVNode = oldNode;
                correctVRev = nodeRevision;
            }
        }
        return correctVNode;
    }

    protected static void printNode(Node node) throws RepositoryException {
        System.out.println("Node: " + node.getName());
        PropertyIterator pi = node.getProperties();
        while (pi.hasNext()) {
            Property p = pi.nextProperty();
            boolean isProtected = p.getDefinition().isProtected();
            boolean isMultiple = p.getDefinition().isMultiple();
            String status = "";
            if (isProtected) {
                status = "protected";
            }
            if (isMultiple) {
                System.out.println(" p " + p.getName() + " multiple " + status);
                continue;
            }
            System.out.println(" p " + p.getName() + " " + status + " =" + p.getString());
        }
    }

    private static void setupFileNode(Node n) throws RepositoryException {
        String mimeType = "text/plain";
        String encoding = "UTF-8";
        long lastModifiedTime = System.currentTimeMillis();
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(lastModifiedTime);
        Node resNode = n.addNode("jcr:content", "nt:resource");
        resNode.setProperty("jcr:mimeType", mimeType);
        resNode.setProperty("jcr:encoding", encoding);
        resNode.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(new byte[0]));
        resNode.setProperty("jcr:lastModified", lastModified);
    }

    protected static void smartCheckout(Node node, boolean openParent) throws RepositoryException {
        Node parentNode;
        if (!node.isCheckedOut() && node.isNodeType("mix:versionable")) {
            node.checkout();
        }
        if (openParent && !(parentNode = node.getParent()).isCheckedOut()) {
            parentNode.checkout();
        }
    }
}

