/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.ui;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.html.HtmlDataTable;
import org.openl.commons.web.jsf.FacesUtils;
import org.openl.rules.ui.WebStudio;
import org.openl.rules.webstudio.web.util.WebStudioUtils;
import org.openl.util.StringTool;
import org.openl.util.benchmark.BenchmarkInfo;
import org.openl.util.benchmark.BenchmarkOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkMethodBean {
    private WebStudio studio;
    private ArrayList<BenchmarkInfo> benchmarkResults = new ArrayList();
    private BenchmarkInfo[] comparedBenchmarks = new BenchmarkInfo[0];
    private BenchmarkOrder[] benchmarkOrders;
    private boolean[] bencmarkSelected;
    private HtmlDataTable htmlDataTableBM;
    private HtmlDataTable htmlDataTableBMCompared;

    public void addLastBenchmark() {
        String elementUri = this.getElementUri();
        String testName = this.getTestName();
        String testID = this.getTestID();
        String testDescr = this.getTestDescr();
        try {
            BenchmarkInfo buLast = this.studio.getModel().benchmarkElement(elementUri, testName, testID, testDescr, 3000);
            this.studio.addBenchmark(buLast);
            this.benchmarkResults.add(buLast);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        this.comparedBenchmarks = new BenchmarkInfo[0];
    }

    public String compare() {
        this.compareBenchmarks();
        return null;
    }

    private void compareBenchmarks() {
        BenchmarkInfo[] benchmarks = this.studio.getBenchmarks();
        this.comparedBenchmarks = new BenchmarkInfo[benchmarks.length];
        for (int i = 0; i < benchmarks.length; ++i) {
            if (!this.bencmarkSelected[this.benchmarkResults.indexOf(benchmarks[i])]) continue;
            this.comparedBenchmarks[i] = benchmarks[i];
        }
        this.benchmarkOrders = BenchmarkInfo.order((BenchmarkInfo[])this.comparedBenchmarks);
    }

    public String delete() {
        this.deleteBenchmark();
        return null;
    }

    private void deleteBenchmark() {
        BenchmarkInfo[] benchmarks = this.studio.getBenchmarks();
        for (int i = benchmarks.length - 1; i >= 0; --i) {
            int indexOfBenchmark = this.benchmarkResults.indexOf(benchmarks[i]);
            if (!this.bencmarkSelected[indexOfBenchmark]) continue;
            this.studio.removeBenchmark(i);
            this.benchmarkResults.remove(i);
        }
        this.comparedBenchmarks = new BenchmarkInfo[0];
    }

    public int getBenchmarkCount() {
        return this.benchmarkResults.size() + 1;
    }

    public List<BenchmarkInfo> getBenchmarks() {
        this.studio = WebStudioUtils.getWebStudio();
        if (FacesUtils.getRequestParameter((String)"uri") != null) {
            this.addLastBenchmark();
        }
        BenchmarkInfo[] benchmarks = this.studio.getBenchmarks();
        this.benchmarkResults.clear();
        for (BenchmarkInfo bi : benchmarks) {
            this.benchmarkResults.add(bi);
        }
        this.bencmarkSelected = new boolean[this.benchmarkResults.size()];
        return this.benchmarkResults;
    }

    public boolean getBencmarkSelected() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return this.bencmarkSelected[this.benchmarkResults.indexOf(bi)];
    }

    public List<BenchmarkInfo> getComparedBenchmarks() {
        ArrayList<BenchmarkInfo> benchmarks = new ArrayList<BenchmarkInfo>();
        for (int i = 0; i < this.comparedBenchmarks.length; ++i) {
            if (this.comparedBenchmarks[i] == null) continue;
            benchmarks.add(this.comparedBenchmarks[i]);
        }
        return benchmarks;
    }

    public int getComparedI() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBMCompared.getRowData();
        return this.benchmarkResults.indexOf(bi) + 1;
    }

    public int getComparedOrder() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBMCompared.getRowData();
        return this.benchmarkOrders[this.benchmarkResults.indexOf(bi)].getOrder();
    }

    public String getComparedRatio() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBMCompared.getRowData();
        double ratio = this.benchmarkOrders[this.benchmarkResults.indexOf(bi)].getRatio();
        return BenchmarkInfo.printDouble((double)ratio, (int)2);
    }

    public String getComparedRunsunitsec() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBMCompared.getRowData();
        return bi.runsunitsec();
    }

    private String getElementUri() {
        return FacesUtils.getRequestParameter((String)"uri");
    }

    public HtmlDataTable getHtmlDataTableBM() {
        return this.htmlDataTableBM;
    }

    public HtmlDataTable getHtmlDataTableBMCompared() {
        return this.htmlDataTableBMCompared;
    }

    public int getI() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return this.benchmarkResults.indexOf(bi) + 1;
    }

    public String getMsrun() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.msrun();
    }

    public String getMsrununit() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.msrununit();
    }

    public String getRunssec() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.runssec();
    }

    public String getRunsunitsec() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.runsunitsec();
    }

    public String getStyleForOrder() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBMCompared.getRowData();
        switch (this.benchmarkOrders[this.benchmarkResults.indexOf(bi)].getOrder()) {
            case 1: {
                return "color: red; font-size: large;";
            }
            case 2: {
                return "color: green; font-size: medium;";
            }
            case 3: {
                return "color: blue;font-size: medium;";
            }
        }
        return "color: black;";
    }

    public String getTestDescr() {
        String testDescr = FacesUtils.getRequestParameter((String)"testDescr");
        if (testDescr == null) {
            testDescr = "";
        }
        return testDescr;
    }

    private String getTestID() {
        return FacesUtils.getRequestParameter((String)"testID");
    }

    public String getTestName() {
        String testName = FacesUtils.getRequestParameter((String)"testName");
        if (testName != null) {
            return StringTool.decodeURL((String)testName);
        }
        return "";
    }

    public String getUnitName() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.unitName();
    }

    public int getUnitRuns() {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        return bi.getUnit().nUnitRuns();
    }

    public void setBencmarkSelected(boolean bencmarkSelected) {
        BenchmarkInfo bi = (BenchmarkInfo)this.htmlDataTableBM.getRowData();
        this.bencmarkSelected[this.benchmarkResults.indexOf((Object)bi)] = bencmarkSelected;
    }

    public void setHtmlDataTableBM(HtmlDataTable htmlDataTable) {
        this.htmlDataTableBM = htmlDataTable;
    }

    public void setHtmlDataTableBMCompared(HtmlDataTable htmlDataTableBMComapre) {
        this.htmlDataTableBMCompared = htmlDataTableBMComapre;
    }
}

